/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.util.Pair;
import org.tinymediamanager.scraper.util.UrlUtil;

public class Url {
    private static final Logger LOGGER = LoggerFactory.getLogger(Url.class);
    protected OkHttpClient client;
    protected static final String USER_AGENT = "User-Agent";
    protected static final List<String> KNOWN_HEADERS = Arrays.asList("accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "cookie", "customrequest", "noshout", "postdata", "referer", "user-agent", "seekable", "sslcipherlist", "Via");
    protected int responseCode = 0;
    protected String responseMessage = "";
    protected Charset responseCharset = null;
    protected String responseContentType = "";
    protected long responseContentLength = -1L;
    protected String url = null;
    protected Headers headersResponse = null;
    protected List<Pair<String, String>> headersRequest = new ArrayList<Pair<String, String>>();
    protected URI uri = null;
    protected Call call = null;
    protected Request request = null;
    protected Response response = null;

    public String getHeader(String header) {
        if (this.headersResponse == null) {
            return "";
        }
        String h = this.headersResponse.get(header);
        if (StringUtils.isBlank((CharSequence)h)) {
            return "";
        }
        return h;
    }

    public Headers getHeadersResponse() {
        return this.headersResponse;
    }

    public Url(String url) throws MalformedURLException {
        this.client = TmmHttpClient.getHttpClient();
        this.url = url;
        if (url.contains("|")) {
            this.splitHeadersFromUrl();
        }
        try {
            this.createUri(url);
        }
        catch (Exception e) {
            throw new MalformedURLException(url + " - " + e.getMessage());
        }
        this.addHeader(USER_AGENT, UrlUtil.generateUA());
    }

    private void createUri(String url) throws Exception {
        block2: {
            try {
                this.uri = this.morphStringToUri(url);
            }
            catch (MalformedURLException e) {
                if (url.contains("://")) break block2;
                this.uri = Paths.get(url, new String[0]).toUri();
            }
        }
    }

    protected Url() {
    }

    protected void splitHeadersFromUrl() {
        Pattern p = Pattern.compile(".*\\|(.*?)=(.*?)$");
        Matcher m = p.matcher(this.url);
        if (m.find() && KNOWN_HEADERS.contains(m.group(1).toLowerCase(Locale.ROOT))) {
            this.url = this.url.substring(0, m.start(1) - 1);
            this.addHeader(m.group(1), m.group(2));
        }
    }

    protected URI morphStringToUri(String urlToMorph) throws MalformedURLException, URISyntaxException {
        URL newUrl = new URL(urlToMorph);
        return new URI(newUrl.getProtocol(), newUrl.getUserInfo(), newUrl.getHost(), newUrl.getPort(), newUrl.getPath(), newUrl.getQuery(), newUrl.getRef());
    }

    public void setUserAgent(String userAgent) {
        this.addHeader(USER_AGENT, userAgent);
    }

    public URL getUrl() throws IOException {
        return new URL(this.url);
    }

    public void addHeader(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        LOGGER.trace("add HTTP header: {}={}", (Object)key, (Object)value);
        for (int i = this.headersRequest.size() - 1; i >= 0; --i) {
            Pair<String, String> header = this.headersRequest.get(i);
            if (!key.equals(header.first())) continue;
            this.headersRequest.remove(i);
        }
        this.headersRequest.add(new Pair<String, String>(key, value));
    }

    public void addHeader(Pair<String, String> header) {
        this.headersRequest.add(header);
    }

    public void addHeaders(List<Pair<String, String>> headers) {
        this.headersRequest.addAll(headers);
    }

    public InputStream getInputStream() throws IOException, InterruptedException {
        return this.getInputStream(false);
    }

    public InputStream getInputStream(boolean headRequest) throws IOException, InterruptedException {
        if (this.url.startsWith("file:")) {
            String newUrl = this.url.replace("file:/", "");
            File file = new File(newUrl);
            return new FileInputStream(file);
        }
        InputStream is = null;
        String logUrl = this.url.replaceAll("api_?key=\\w+", "api_key=<API_KEY>").replaceAll("api/\\d+\\w+", "api/<API_KEY>");
        LOGGER.debug("getting {}", (Object)logUrl);
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(this.url);
        if (headRequest) {
            requestBuilder.head();
        }
        for (Pair<String, String> header : this.headersRequest) {
            requestBuilder.addHeader(header.first(), header.second());
        }
        this.request = requestBuilder.build();
        try {
            this.call = this.client.newCall(this.request);
            this.response = this.call.execute();
            this.headersResponse = this.response.headers();
            this.responseCode = this.response.code();
            this.responseMessage = this.response.message();
            if (this.responseCode < 200 || this.responseCode >= 400) {
                this.cleanup();
                LOGGER.debug("bad http response: {} - {}", (Object)this.responseCode, (Object)this.responseMessage);
                throw new HttpException(this.url, this.responseCode, this.responseMessage);
            }
            if (this.response.body().contentType() != null) {
                this.responseCharset = this.response.body().contentType().charset();
                this.responseContentType = this.response.body().contentType().toString();
            }
            this.responseContentLength = this.response.body().contentLength();
            if (headRequest) {
                this.response.close();
                return new NullInputStream(0L);
            }
            is = this.getInputstreamInternal(this.response);
        }
        catch (SSLHandshakeException e) {
            this.cleanup();
            throw new IOException("SSL verification failed for '" + UrlUtil.getDomainUrl(this.url) + "'");
        }
        catch (InterruptedIOException | IllegalStateException e) {
            this.cleanup();
            LOGGER.debug("aborted request: {} - {}", (Object)logUrl, (Object)e.getMessage());
            throw new InterruptedException();
        }
        catch (UnknownHostException e) {
            this.cleanup();
            LOGGER.error("proxy or host not found/reachable - {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.cleanup();
            LOGGER.error("Unexpected exception getting url " + logUrl + " - " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return is;
    }

    protected InputStream getInputstreamInternal(Response response) throws IOException {
        return new ByteArrayInputStream(response.body().bytes());
    }

    public InputStream getInputStreamWithRetry(int retries) throws Exception {
        if (retries <= 0) {
            return null;
        }
        InputStream is = null;
        Exception exception = null;
        int counter = 0;
        do {
            ++counter;
            try {
                is = this.getInputStream();
            }
            catch (InterruptedIOException | InterruptedException e) {
                throw new InterruptedException();
            }
            catch (Exception e) {
                LOGGER.warn("problem fetching the url: {}", (Object)e.getMessage());
                exception = e;
            }
            if (this.getStatusCode() == 403 || this.getStatusCode() == 404) {
                return null;
            }
            if (is != null || this.getStatusCode() > 0 && this.getStatusCode() < 500) {
                return is;
            }
            if (Thread.interrupted()) {
                return null;
            }
            LOGGER.info("could not fetch: {} - retrying", (Object)this.url);
        } while (counter <= retries);
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    protected void cleanup() {
        if (this.call != null) {
            this.call.cancel();
        }
        if (this.response != null) {
            this.response.close();
        }
    }

    public boolean isFault() {
        return this.responseCode >= 400;
    }

    public int getStatusCode() {
        return this.responseCode;
    }

    public String getStatusLine() {
        return this.responseMessage;
    }

    public byte[] getBytes() throws IOException, InterruptedException {
        try (InputStream is = this.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public byte[] getBytesWithRetry(int retries) throws Exception {
        try (InputStream is = this.getInputStreamWithRetry(retries);){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean download(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean download(Path file) {
        return this.download(file.toFile());
    }

    public Charset getCharset() {
        if (this.responseCharset == null) {
            return Charset.defaultCharset();
        }
        return this.responseCharset;
    }

    public String getContentEncoding() {
        return this.responseContentType;
    }

    public long getContentLength() {
        return this.responseContentLength;
    }

    public String toString() {
        return this.url;
    }
}

