/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Collections;
import java.util.List;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbMovieParser;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;

public class ImdbMovieArtworkProvider
extends ImdbMetadataProvider
implements IMovieArtworkProvider {
    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        if (options.getMediaType() != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        if (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.POSTER) {
            return new ImdbMovieParser(this, EXECUTOR).getMovieArtwork(options);
        }
        return Collections.emptyList();
    }
}

