/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.SortedSet;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbMovieParser;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;

public class ImdbMovieMetadataProvider
extends ImdbMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider {
    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = super.createMediaProviderInfo();
        providerInfo.getConfig().addBoolean("includeTvMovieResults", true);
        providerInfo.getConfig().addBoolean("includeShortResults", false);
        providerInfo.getConfig().addBoolean("includeTvSeriesResults", false);
        providerInfo.getConfig().addBoolean("includeVideogameResults", false);
        providerInfo.getConfig().addBoolean("useTmdbForMovies", false);
        providerInfo.getConfig().addBoolean("scrapeCollectionInfo", false);
        providerInfo.getConfig().addBoolean("localReleaseDate", true);
        providerInfo.getConfig().addBoolean("includePremiereDate", true);
        providerInfo.getConfig().addBoolean("scrapeUncreditedActors", true);
        providerInfo.getConfig().addBoolean("scrapeLanguageNames", true);
        providerInfo.getConfig().addBoolean("scrapeKeywordsPage", false);
        providerInfo.getConfig().addInteger("maxKeywordCount", 10);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        return new ImdbMovieParser(this, EXECUTOR).search(options);
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        return new ImdbMovieParser(this, EXECUTOR).getMovieMetadata(options);
    }
}

