/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbMovieParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbMovieParser.class);

    ImdbMovieParser(IMediaProvider mediaProvider, ExecutorService executor) {
        super(mediaProvider, MediaType.MOVIE, executor);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected boolean isIncludeMovieResults() {
        return true;
    }

    @Override
    protected MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException {
        return this.getMovieMetadata((MovieSearchAndScrapeOptions)options);
    }

    MediaMetadata getMovieMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        MediaMetadata md = new MediaMetadata("imdb");
        if (options.getMetadata() != null && "imdb".equals(options.getMetadata().getProviderId())) {
            LOGGER.debug("IMDB: got metadata from cache: {}", (Object)options.getMetadata());
            return options.getMetadata();
        }
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getMovieImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        md.setId("imdb", imdbId);
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, "/reference"), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
        Future<Document> futureReference = this.executor.submit(worker);
        worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, "/plotsummary"), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
        Future<Document> futurePlotsummary = this.executor.submit(worker);
        worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, "/releaseinfo"), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
        Future<Document> futureReleaseinfo = this.executor.submit(worker);
        Future<Document> futureKeywords = null;
        if (this.isScrapeKeywordsPage()) {
            worker = new ImdbParser.ImdbWorker(this.constructUrl("title/", imdbId, "/keywords"), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
            futureKeywords = this.executor.submit(worker);
        }
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForMovies() || this.isScrapeCollectionInfo()) {
            TmdbMovieWorker worker2 = new TmdbMovieWorker(options);
            futureTmdb = this.executor.submit(worker2);
        }
        try {
            Document releaseinfoDoc;
            Elements elements;
            Element title;
            Document doc = futureReference.get();
            if (doc != null) {
                this.parseReferencePage(doc, options, md);
            }
            if ((doc = futurePlotsummary.get()) != null) {
                this.parsePlotsummaryPage(doc, options, md);
            }
            if ((title = doc.getElementById("tn15title")) != null && !(elements = title.getElementsByClass("main")).isEmpty()) {
                Element element = elements.first();
                String movieTitle = this.cleanString(element.ownText());
                md.setTitle(movieTitle);
            }
            if (futureKeywords != null && (doc = (Document)futureKeywords.get()) != null) {
                this.parseKeywordsPage(doc, options, md);
            }
            if ((releaseinfoDoc = futureReleaseinfo.get()) != null) {
                this.parseReleaseinfoPageAKAs(releaseinfoDoc, options, md);
                this.parseReleaseinfoPage(releaseinfoDoc, options, md);
            }
            md.setId("imdb", imdbId);
        }
        catch (Exception e) {
            LOGGER.error("problem while scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (md.getIds().isEmpty()) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        if (futureTmdb != null && (this.isUseTmdbForMovies() || this.isScrapeCollectionInfo())) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry<String, Object> entry : tmdbMd.getIds().entrySet()) {
                        md.setId(entry.getKey(), entry.getValue());
                    }
                    if (this.isUseTmdbForMovies()) {
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                            md.setTitle(tmdbMd.getTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                            md.setOriginalTitle(tmdbMd.getOriginalTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                            md.setTagline(tmdbMd.getTagline());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                            md.setPlot(tmdbMd.getPlot());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getCollectionName())) {
                            md.setCollectionName(tmdbMd.getCollectionName());
                        }
                    }
                    if (Boolean.TRUE.equals(this.config.getValueAsBool("scrapeCollectionInfo"))) {
                        md.setCollectionName(tmdbMd.getCollectionName());
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().debug("could not get data from tmdb: {}", (Object)e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)md.getOriginalTitle())) {
            md.setOriginalTitle(md.getTitle());
        }
        md.setId("imdb", imdbId);
        return md;
    }

    private MediaMetadata parseReleaseinfoPageAKAs(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        block0: for (Element table : doc.getElementsByTag("table")) {
            if (!table.id().equalsIgnoreCase("akas")) continue;
            Elements rows = table.getElementsByTag("tr");
            for (Element row : rows) {
                Element c1 = (Element)row.getElementsByTag("td").get(0);
                Element c2 = (Element)row.getElementsByTag("td").get(1);
                if (c1 == null || !c1.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
                md.setOriginalTitle(c2.text());
                continue block0;
            }
        }
        Elements rows = doc.getElementsByClass("aka-item");
        for (Element row : rows) {
            Element country = row.getElementsByClass("aka-item__name").first();
            Element title = row.getElementsByClass("aka-item__title").first();
            if (country == null || !country.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
            md.setOriginalTitle(title.text());
            break;
        }
        return md;
    }

    public List<MediaArtwork> getMovieArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        String imdbId = "";
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getMovieImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        MovieSearchAndScrapeOptions movieSearchAndScrapeOptions = new MovieSearchAndScrapeOptions();
        movieSearchAndScrapeOptions.setDataFromOtherOptions(options);
        try {
            List<MediaArtwork> artworks = this.getMetadata(movieSearchAndScrapeOptions).getMediaArt(MediaArtwork.MediaArtworkType.POSTER);
            for (MediaArtwork artwork : artworks) {
                if (!"imdb".equals(artwork.getProviderId())) continue;
                this.adoptArtworkToOptions(artwork, options);
            }
            return artworks;
        }
        catch (NothingFoundException e) {
            LOGGER.debug("nothing found");
            return Collections.emptyList();
        }
    }

    private static class TmdbMovieWorker
    implements Callable<MediaMetadata> {
        private final MovieSearchAndScrapeOptions options;

        TmdbMovieWorker(MovieSearchAndScrapeOptions options) {
            this.options = options;
        }

        @Override
        public MediaMetadata call() {
            try {
                IMovieMetadataProvider tmdb = MediaProviders.getProviderById("tmdb", IMovieMetadataProvider.class);
                if (tmdb == null) {
                    return null;
                }
                MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions(this.options);
                options.setMetadataScraper(new MediaScraper(ScraperType.MOVIE, tmdb));
                return tmdb.getMetadata(options);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

