/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Collections;
import java.util.List;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbMovieParser;
import org.tinymediamanager.scraper.imdb.ImdbTvShowParser;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;

public class ImdbTvShowArtworkProvider
extends ImdbMetadataProvider
implements ITvShowArtworkProvider {
    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        if (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.POSTER) {
            switch (options.getMediaType()) {
                case MOVIE: {
                    return new ImdbMovieParser(this, EXECUTOR).getMovieArtwork(options);
                }
                case TV_SHOW: {
                    return new ImdbTvShowParser(this, EXECUTOR).getTvShowArtwork(options);
                }
            }
        }
        return Collections.emptyList();
    }
}

