/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.List;
import java.util.SortedSet;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbTvShowParser;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;

public class ImdbTvShowMetadataProvider
extends ImdbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowImdbMetadataProvider {
    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = super.createMediaProviderInfo();
        providerInfo.getConfig().addBoolean("includeTvMovieResults", false);
        providerInfo.getConfig().addBoolean("includeShortResults", false);
        providerInfo.getConfig().addBoolean("includeMovieResults", false);
        providerInfo.getConfig().addBoolean("includeVideogameResults", false);
        providerInfo.getConfig().addBoolean("useTmdbForTvShows", false);
        providerInfo.getConfig().addBoolean("localReleaseDate", true);
        providerInfo.getConfig().addBoolean("scrapeUncreditedActors", true);
        providerInfo.getConfig().addBoolean("scrapeLanguageNames", true);
        providerInfo.getConfig().addBoolean("scrapeKeywordsPage", false);
        providerInfo.getConfig().addInteger("maxKeywordCount", 10);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        return new ImdbTvShowParser(this, EXECUTOR).getTvShowMetadata(options);
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        return new ImdbTvShowParser(this, EXECUTOR).getEpisodeMetadata(options);
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        return new ImdbTvShowParser(this, EXECUTOR).search(options);
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        return new ImdbTvShowParser(this, EXECUTOR).getEpisodeList(options);
    }
}

