/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbTvShowParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbTvShowParser.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(60L, 10L);

    ImdbTvShowParser(IMediaProvider metadataProvider, ExecutorService executor) {
        super(metadataProvider, MediaType.TV_SHOW, executor);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected boolean isIncludeTvSeriesResults() {
        return true;
    }

    @Override
    protected MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException {
        switch (options.getMediaType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata((TvShowSearchAndScrapeOptions)options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata((TvShowEpisodeSearchAndScrapeOptions)options);
            }
        }
        return new MediaMetadata("imdb");
    }

    MediaMetadata getTvShowMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        String apiKey;
        MediaMetadata md = new MediaMetadata("imdb");
        try {
            apiKey = this.metadataProvider.getApiKey();
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForTvShows()) {
            TmdbTvShowWorker worker2 = new TmdbTvShowWorker(options);
            futureTmdb = this.executor.submit(worker2);
        }
        String url = apiKey + "title/" + imdbId + "/reference";
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
        Future<Document> futureReference = this.executor.submit(worker);
        url = apiKey + "title/" + imdbId + "/plotsummary";
        worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
        Future<Document> futurePlotsummary = this.executor.submit(worker);
        Future<Document> futureKeywords = null;
        if (this.isScrapeKeywordsPage()) {
            url = apiKey + "title/" + imdbId + "/keywords";
            worker = new ImdbParser.ImdbWorker(this, url, options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
            futureKeywords = this.executor.submit(worker);
        }
        try {
            Document releaseinfoDoc;
            Document doc = futureReference.get();
            if (doc != null) {
                this.parseReferencePage(doc, options, md);
            }
            if ((doc = futurePlotsummary.get()) != null) {
                this.parsePlotsummaryPage(doc, options, md);
            }
            if ((md.getReleaseDate() == null || Boolean.TRUE.equals(this.config.getValueAsBool("localReleaseDate"))) && (releaseinfoDoc = this.executor.submit(worker).get()) != null) {
                this.parseReleaseinfoPage(releaseinfoDoc, options, md);
            }
            if (futureKeywords != null && (doc = futureKeywords.get()) != null) {
                this.parseKeywordsPage(doc, options, md);
            }
            md.setId("imdb", imdbId);
        }
        catch (Exception e) {
            LOGGER.error("problem while scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (md.getIds().isEmpty()) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setId("imdb", imdbId);
        if (futureTmdb != null) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry<String, Object> entry : tmdbMd.getIds().entrySet()) {
                        md.setId(entry.getKey(), entry.getValue());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                        md.setTitle(tmdbMd.getTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                        md.setOriginalTitle(tmdbMd.getOriginalTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                        md.setTagline(tmdbMd.getTagline());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                        md.setPlot(tmdbMd.getPlot());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not fetch data from TMDB: {}", (Object)e.getMessage());
            }
        }
        return md;
    }

    MediaMetadata getEpisodeMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata("imdb");
        String showId = "" + options.getTvShowIds().get("imdb");
        String episodeId = options.getIdAsString("imdb");
        if (!MetadataUtil.isValidImdbId(episodeId)) {
            episodeId = "";
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && StringUtils.isBlank((CharSequence)episodeId)) {
            throw new MissingIdException("episodeNr", "seasonNr");
        }
        MediaMetadata wantedEpisode = null;
        if (seasonNr >= 0 && episodeNr > 0) {
            if (!MetadataUtil.isValidImdbId(showId)) {
                LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
                throw new MissingIdException(new String[]{"imdb"});
            }
            List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
            if (StringUtils.isNotBlank((CharSequence)episodeId)) {
                for (MediaMetadata episode : episodes) {
                    if (!episodeId.equals(episode.getId("imdb"))) continue;
                    wantedEpisode = episode;
                    break;
                }
            }
            if (wantedEpisode == null) {
                for (MediaMetadata episode : episodes) {
                    if (episode.getSeasonNumber() != seasonNr || episode.getEpisodeNumber() != episodeNr) continue;
                    wantedEpisode = episode;
                    break;
                }
            }
        }
        if (wantedEpisode == null && StringUtils.isBlank((CharSequence)episodeId)) {
            LOGGER.warn("episode not found");
            throw new NothingFoundException();
        }
        ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(this.executor);
        Future<MediaMetadata> futureTmdb = null;
        if (wantedEpisode != null && wantedEpisode.getId("imdb") instanceof String) {
            episodeId = (String)wantedEpisode.getId("imdb");
            md.setEpisodeNumber(wantedEpisode.getEpisodeNumber());
            md.setSeasonNumber(wantedEpisode.getSeasonNumber());
            md.setTitle(wantedEpisode.getTitle());
            md.setPlot(wantedEpisode.getPlot());
            md.setRatings(wantedEpisode.getRatings());
            md.setReleaseDate(wantedEpisode.getReleaseDate());
            if (this.isUseTmdbForTvShows()) {
                TmdbTvShowEpisodeWorker worker2 = new TmdbTvShowEpisodeWorker(options);
                futureTmdb = compSvcTmdb.submit(worker2);
            }
        }
        if (MetadataUtil.isValidImdbId(episodeId)) {
            md.setId("imdb", episodeId);
            if (MetadataUtil.isValidImdbId(episodeId)) {
                ExecutorCompletionService compSvcImdb = new ExecutorCompletionService(this.executor);
                Object worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", episodeId, "/reference"), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
                Future futureReference = compSvcImdb.submit(worker);
                Future futureKeywords = null;
                if (this.isScrapeKeywordsPage()) {
                    worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", episodeId, "/keywords"), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2());
                    futureKeywords = compSvcImdb.submit(worker);
                }
                try {
                    Document docKeywords;
                    Document doc = (Document)futureReference.get();
                    if (doc != null) {
                        this.parseEpisodeReference(doc, md, episodeId);
                    }
                    if (futureKeywords != null && (docKeywords = (Document)futureKeywords.get()) != null) {
                        this.parseKeywordsPage(docKeywords, options, md);
                    }
                }
                catch (Exception e) {
                    LOGGER.trace("problem parsing: {}", (Object)e.getMessage());
                }
            }
        }
        if (futureTmdb != null) {
            try {
                MediaMetadata tmdbMd = (MediaMetadata)futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry<String, Object> entry : tmdbMd.getIds().entrySet()) {
                        md.setId(entry.getKey(), entry.getValue());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                        md.setTitle(tmdbMd.getTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                        md.setOriginalTitle(tmdbMd.getOriginalTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                        md.setTagline(tmdbMd.getTagline());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                        md.setPlot(tmdbMd.getPlot());
                    }
                    if (md.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).isEmpty() && !tmdbMd.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).isEmpty()) {
                        MediaArtwork thumb = tmdbMd.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).get(0);
                        md.addMediaArt(thumb);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("could not get cast page: {}", (Object)e.getMessage());
            }
        }
        return md;
    }

    List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Document doc;
        OnDiskCachedUrl url;
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        String imdbId = options.getImdbId();
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            throw new MissingIdException(new String[]{"imdb"});
        }
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(imdbId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        episodes = new ArrayList<MediaMetadata>();
        try {
            url = new OnDiskCachedUrl(this.constructUrl("/title/", imdbId, "/episodes?season=1"), 300, TimeUnit.SECONDS);
            url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2()));
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        ArrayList<String> availableSeasons = new ArrayList<String>();
        try (InputStream is = url.getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            if (doc != null) {
                this.parseEpisodeList(1, episodes, doc);
                Element select = doc.getElementById("bySeason");
                if (select != null) {
                    for (Element option : select.getElementsByTag("option")) {
                        String value = option.attr("value");
                        if (!StringUtils.isNotBlank((CharSequence)value) || "1".equals(value)) continue;
                        availableSeasons.add(value);
                    }
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (String seasonAsString : availableSeasons) {
            InMemoryCachedUrl seasonUrl;
            int season;
            try {
                season = Integer.parseInt(seasonAsString);
            }
            catch (Exception e) {
                LOGGER.debug("could not parse season number - {}", (Object)e.getMessage());
                continue;
            }
            try {
                seasonUrl = new InMemoryCachedUrl(this.constructUrl("/title/", imdbId, "/epdate?season=" + season));
                seasonUrl.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2()));
            }
            catch (Exception e) {
                LOGGER.error("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            try {
                InputStream is = ((Url)seasonUrl).getInputStream();
                try {
                    doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                    if (this.parseEpisodeList(season, episodes, doc)) continue;
                    break;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("problem parsing ep list: {}", (Object)e.getMessage());
            }
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(imdbId + "_" + options.getLanguage().getLanguage(), episodes);
        }
        return episodes;
    }

    private boolean parseEpisodeList(int season, List<MediaMetadata> episodes, Document doc) {
        Pattern unknownPattern = Pattern.compile("Unknown");
        Pattern seasonEpisodePattern = Pattern.compile("S([0-9]*), Ep([0-9]*)");
        int episodeCounter = 0;
        Elements tables = doc.getElementsByClass("eplist");
        if (tables.isEmpty()) {
            return false;
        }
        for (Element table : tables) {
            Elements rows = table.getElementsByClass("list_item");
            for (Element row : rows) {
                Matcher matcher = season <= 0 ? unknownPattern.matcher(row.text()) : seasonEpisodePattern.matcher(row.text());
                if (!matcher.find() || season > 0 && matcher.groupCount() < 2) continue;
                try {
                    Element image;
                    Element releaseDate;
                    Element ratingElement;
                    Element plot;
                    MediaMetadata ep = new MediaMetadata("imdb");
                    if (season <= 0) {
                        ep.setSeasonNumber(0);
                        ep.setEpisodeNumber(++episodeCounter);
                    } else {
                        ep.setSeasonNumber(Integer.parseInt(matcher.group(1)));
                        ep.setEpisodeNumber(Integer.parseInt(matcher.group(2)));
                    }
                    if (season > 0 && season != ep.getSeasonNumber()) {
                        return false;
                    }
                    Elements anchors = row.getElementsByAttributeValueStarting("href", "/title/tt");
                    for (Element anchor : anchors) {
                        if (!"name".equals(anchor.attr("itemprop"))) continue;
                        ep.setTitle(anchor.text());
                        break;
                    }
                    String id = "";
                    Matcher idMatcher = IMDB_ID_PATTERN.matcher(((Element)anchors.get(0)).attr("href"));
                    while (idMatcher.find()) {
                        if (idMatcher.group(1) == null) continue;
                        id = idMatcher.group(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        ep.setId("imdb", id);
                    }
                    if ((plot = row.getElementsByClass("item_description").first()) != null) {
                        ep.setPlot(plot.ownText());
                    }
                    if ((ratingElement = row.getElementsByClass("ipl-rating-star__rating").first()) != null) {
                        String ratingAsString = ratingElement.ownText().replace(",", ".");
                        Element votesElement = row.getElementsByClass("ipl-rating-star__total-votes").first();
                        if (votesElement != null) {
                            String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                            try {
                                MediaRating rating = new MediaRating("imdb");
                                rating.setRating(Float.parseFloat(ratingAsString));
                                rating.setVotes(MetadataUtil.parseInt(countAsString));
                                ep.addRating(rating);
                            }
                            catch (Exception e) {
                                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                            }
                        }
                    }
                    if ((releaseDate = row.getElementsByClass("airdate").first()) != null) {
                        ep.setReleaseDate(this.parseDate(releaseDate.ownText()));
                    }
                    if ((image = row.getElementsByTag("img").first()) != null) {
                        String posterUrl = image.attr("src");
                        posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                        posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                        if (StringUtils.isNotBlank((CharSequence)(posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "")))) {
                            MediaArtwork ma = new MediaArtwork("imdb", MediaArtwork.MediaArtworkType.THUMB);
                            ma.setPreviewUrl(posterUrl);
                            ma.setDefaultUrl(posterUrl);
                            ma.setOriginalUrl(posterUrl);
                            ep.addMediaArt(ma);
                        }
                    }
                    episodes.add(ep);
                }
                catch (Exception e) {
                    LOGGER.warn("failed parsing: {} for ep data - {}", (Object)row.text(), (Object)e.getMessage());
                }
            }
        }
        return true;
    }

    private void parseEpisodeReference(Document doc, MediaMetadata md, String imdbId) {
        Element writersElement;
        Element castTableElement;
        Element directorsElement;
        Element ratingElement;
        Element poster;
        Element releaseDateElement;
        Element titlereference;
        int yearStart;
        Element title;
        Object episodeTitle;
        Element year;
        Element header = doc.getElementsByClass("titlereference-header").first();
        if (header != null && (year = header.getElementsByClass("titlereference-title-year").first()) != null && StringUtils.isNotBlank((CharSequence)(episodeTitle = this.cleanString(year.parent().ownText())))) {
            md.setTitle((String)episodeTitle);
        }
        if (StringUtils.isBlank((CharSequence)md.getTitle()) && (title = doc.getElementsByAttributeValue("name", "title").first()) != null && (yearStart = ((String)(episodeTitle = this.cleanString(title.attr("content")))).lastIndexOf(40)) > 0) {
            episodeTitle = ((String)episodeTitle).substring(0, yearStart - 1).trim();
            md.setTitle((String)episodeTitle);
        }
        if ((titlereference = doc.getElementsByClass("titlereference-section-overview").first()) != null) {
            for (Element child : titlereference.children()) {
                String plot;
                if (!"div".equals(child.tagName()) || !child.classNames().isEmpty() || !StringUtils.isNotBlank((CharSequence)(plot = child.text()))) continue;
                md.setPlot(plot);
                break;
            }
        }
        if ((releaseDateElement = doc.getElementsByAttributeValue("href", "/title/" + imdbId + "/releaseinfo").first()) != null) {
            String releaseDateText = releaseDateElement.ownText();
            int startOfCountry = releaseDateText.indexOf(40);
            if (startOfCountry > 0) {
                releaseDateText = releaseDateText.substring(0, startOfCountry - 1).trim();
            }
            md.setReleaseDate(this.parseDate(releaseDateText));
        }
        if ((poster = doc.getElementsByAttributeValue("property", "og:image").first()) != null) {
            int startOfExtension;
            int parameterStart;
            Object posterUrl = poster.attr("content");
            int fileStart = ((String)posterUrl).lastIndexOf(47);
            if (fileStart > 0 && (parameterStart = ((String)posterUrl).indexOf(95, fileStart)) > 0 && (startOfExtension = ((String)posterUrl).lastIndexOf(46)) > parameterStart) {
                posterUrl = ((String)posterUrl).substring(0, parameterStart) + ((String)posterUrl).substring(startOfExtension);
            }
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, (String)posterUrl);
        }
        if ((ratingElement = doc.getElementsByClass("ipl-rating-star__rating").first()) != null) {
            String ratingAsString = ratingElement.ownText().replace(",", ".");
            Element votesElement = doc.getElementsByClass("ipl-rating-star__total-votes").first();
            if (votesElement != null) {
                String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                try {
                    MediaRating rating = new MediaRating("imdb");
                    rating.setRating(Float.parseFloat(ratingAsString));
                    rating.setVotes(MetadataUtil.parseInt(countAsString));
                    md.addRating(rating);
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                }
            }
        }
        for (directorsElement = doc.getElementById("directors"); directorsElement != null && !"header".equals(directorsElement.tag().getName()); directorsElement = directorsElement.parent()) {
        }
        if (directorsElement != null) {
            directorsElement = directorsElement.nextElementSibling();
        }
        if (directorsElement != null) {
            for (Element directorElement : directorsElement.getElementsByClass("name")) {
                Matcher matcher;
                String director = directorElement.text().trim();
                Person cm = new Person(Person.Type.DIRECTOR, director);
                Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId("imdb", matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        if ((castTableElement = doc.getElementsByClass("cast_list").first()) != null) {
            Elements castListLabel = castTableElement.getElementsByClass("castlist_label");
            Elements tr = castTableElement.getElementsByTag("tr");
            for (Element row : tr) {
                if (!this.isScrapeUncreditedActors() && castListLabel.size() > 1 && row.children().contains(castListLabel.get(1))) break;
                Person cm = this.parseCastMember(row);
                if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName()) || !StringUtils.isNotEmpty((CharSequence)cm.getRole())) continue;
                cm.setType(Person.Type.ACTOR);
                md.addCastMember(cm);
            }
        }
        for (writersElement = doc.getElementById("writers"); writersElement != null && !"header".equals(writersElement.tag().getName()); writersElement = writersElement.parent()) {
        }
        if (writersElement != null) {
            writersElement = writersElement.nextElementSibling();
        }
        if (writersElement != null) {
            Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Element writerElement : writersElements) {
                Matcher matcher;
                String writer = this.cleanString(writerElement.ownText());
                Person cm = new Person(Person.Type.WRITER, writer);
                Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId("imdb", matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
    }

    public List<MediaArtwork> getTvShowArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        String imdbId = "";
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getTvShowImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = new TvShowSearchAndScrapeOptions();
        tvShowSearchAndScrapeOptions.setDataFromOtherOptions(options);
        try {
            List<MediaArtwork> artworks = this.getMetadata(tvShowSearchAndScrapeOptions).getMediaArt(MediaArtwork.MediaArtworkType.POSTER);
            for (MediaArtwork artwork : artworks) {
                this.adoptArtworkToOptions(artwork, options);
            }
            return artworks;
        }
        catch (NothingFoundException e) {
            LOGGER.debug("nothing found");
            return Collections.emptyList();
        }
    }

    private static class TmdbTvShowEpisodeWorker
    implements Callable<MediaMetadata> {
        private final TvShowEpisodeSearchAndScrapeOptions options;

        TmdbTvShowEpisodeWorker(TvShowEpisodeSearchAndScrapeOptions options) {
            this.options = options;
        }

        @Override
        public MediaMetadata call() {
            try {
                ITvShowMetadataProvider tmdb = MediaProviders.getProviderById("tmdb", ITvShowMetadataProvider.class);
                if (tmdb == null) {
                    return null;
                }
                TvShowEpisodeSearchAndScrapeOptions scrapeOptions = new TvShowEpisodeSearchAndScrapeOptions(this.options);
                scrapeOptions.setMetadataScraper(new MediaScraper(ScraperType.TV_SHOW, tmdb));
                return tmdb.getMetadata(scrapeOptions);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class TmdbTvShowWorker
    implements Callable<MediaMetadata> {
        private final TvShowSearchAndScrapeOptions options;

        TmdbTvShowWorker(TvShowSearchAndScrapeOptions options) {
            this.options = options;
        }

        @Override
        public MediaMetadata call() {
            try {
                ITvShowMetadataProvider tmdb = MediaProviders.getProviderById("tmdb", ITvShowMetadataProvider.class);
                if (tmdb == null) {
                    return null;
                }
                TvShowSearchAndScrapeOptions scrapeOptions = new TvShowSearchAndScrapeOptions(this.options);
                scrapeOptions.setMetadataScraper(new MediaScraper(ScraperType.TV_SHOW, tmdb));
                return tmdb.getMetadata(scrapeOptions);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

