/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.util.DOMUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KodiTvShowMetadataProvider
extends AbstractKodiMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiTvShowMetadataProvider.class);
    private static final String EPISODEGUIDE = "episodeguide";

    public KodiTvShowMetadataProvider(KodiScraper scraper) {
        super(scraper);
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled();
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        SortedSet<MediaSearchResult> results = this._search(options);
        if (results.isEmpty() && options.getSearchYear() > 0) {
            LOGGER.info("Search found nothing, try again without year...");
            options.setSearchYear(-1);
            results = this._search(options);
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        LOGGER.debug("getMetadata(): {}", (Object)options);
        return this._getMetadata(options);
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        MediaMetadata md = new MediaMetadata(this.scraper.getProviderInfo().getId());
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("dvdSeasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("dvdEpisodeNr", -1);
        }
        if (seasonNr == -1 || episodeNr == -1) {
            LOGGER.warn("no aired date/season number/episode number found");
            return md;
        }
        LOGGER.debug("search for S{} E{}", (Object)this.lz(seasonNr), (Object)this.lz(episodeNr));
        String showId = options.getIdAsString(this.scraper.getProviderInfo().getId());
        if (showId == null) {
            LOGGER.error("Could not find showId - please scrape show first!");
            return null;
        }
        String epXml = KodiMetadataProvider.XML_CACHE.get(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(seasonNr) + "_E" + this.lz(episodeNr));
        if (epXml == null) {
            try {
                this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
                epXml = KodiMetadataProvider.XML_CACHE.get(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(seasonNr) + "_E" + this.lz(episodeNr));
            }
            catch (Exception e) {
                LOGGER.error("Could not fetch episodeslist!", (Throwable)e);
            }
        }
        try {
            Document epListDoc = this.parseXmlString(epXml);
            Element el = epListDoc.getDocumentElement();
            int season = DOMUtils.getElementIntValue(el, "season");
            int ep = DOMUtils.getElementIntValue(el, "epnum");
            String id = DOMUtils.getElementValue(el, "id");
            String title = DOMUtils.getElementValue(el, "title");
            KodiUrl epUrl = new KodiUrl(DOMUtils.getElementValue(el, "url"));
            LOGGER.trace("Getting episode details S{} E{} - {}", new Object[]{this.lz(season), this.lz(ep), title});
            String xmlDetails = this.processor.getEpisodeDetails(epUrl, id);
            LOGGER.trace("******** BEGIN EPISODE DETAILS XML ***********");
            LOGGER.trace(xmlDetails);
            LOGGER.trace("******** END EPISODE DETAILS XML ***********");
            Document epDetailXml = this.parseXmlString(xmlDetails);
            Element epXmlEl = epDetailXml.getDocumentElement();
            this.addMetadata(md, epXmlEl);
            md.setEpisodeNumber(ep);
            md.setSeasonNumber(season);
            LOGGER.trace("MetaData: {}", (Object)md);
            KodiMetadataProvider.XML_CACHE.put(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(season) + "_E" + this.lz(ep) + "_DETAIL", xmlDetails);
        }
        catch (Exception e) {
            LOGGER.error("Could not get episode details!");
        }
        return md;
    }

    @Override
    protected void processXmlContent(String xmlDetails, MediaMetadata md, MediaSearchResult result) throws Exception {
        if (xmlDetails == null || StringUtils.isEmpty((CharSequence)xmlDetails)) {
            LOGGER.debug("Cannot process empty Xml Contents.");
            return;
        }
        LOGGER.trace("******* BEGIN XML ***********");
        LOGGER.trace(xmlDetails);
        LOGGER.trace("******* END XML ***********");
        Document xml = this.parseXmlString(xmlDetails);
        this.addMetadata(md, xml.getDocumentElement());
        String showId = md.getId(this.scraper.getProviderInfo().getId()).toString();
        String episodeUrl = this.innerXml(DOMUtils.getElementByTagName(xml.getDocumentElement(), EPISODEGUIDE));
        if (StringUtils.isEmpty((CharSequence)episodeUrl)) {
            LOGGER.warn("No Episode Data!");
        } else {
            KodiMetadataProvider.XML_CACHE.put(this.scraper.getProviderInfo().getId() + "_" + showId + "_EPISODEGUIDE_URL", episodeUrl);
            md.addExtraData(EPISODEGUIDE, episodeUrl);
            result.setMetadata(md);
        }
        LOGGER.trace("MetaData: {}", (Object)md);
        KodiMetadataProvider.XML_CACHE.put(this.scraper.getProviderInfo().getId() + "_" + showId + "_" + result.getId(), xmlDetails);
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        return this._getEpisodeList(options);
    }

    private List<MediaMetadata> _getEpisodeList(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        ArrayList<MediaMetadata> episodeList = new ArrayList<MediaMetadata>();
        String showId = options.getIdAsString(this.scraper.getProviderInfo().getId());
        if (StringUtils.isBlank((CharSequence)showId)) {
            LOGGER.error("Could not find showId - please scrape show first!");
            throw new MissingIdException(new String[]{"Could not find showId - please scrape show first!"});
        }
        String episodeguide = KodiMetadataProvider.XML_CACHE.get(this.scraper.getProviderInfo().getId() + "_" + showId + "_EPISODEGUIDE_URL");
        if (episodeguide == null || episodeguide.isEmpty()) {
            if (options.getMetadata() != null) {
                episodeguide = options.getMetadata().getExtraData(EPISODEGUIDE).toString();
            }
            if (episodeguide == null || episodeguide.isEmpty()) {
                LOGGER.error("Could not find episodenguid url - you wanna scrape the show first!");
                return episodeList;
            }
        }
        try {
            String epListXml = KodiMetadataProvider.XML_CACHE.get(this.scraper.getProviderInfo().getId() + "_" + showId + "_episodeguide");
            if (epListXml == null) {
                KodiUrl url = new KodiUrl(episodeguide);
                epListXml = this.processor.getEpisodeList(url);
                KodiMetadataProvider.XML_CACHE.put(this.scraper.getProviderInfo().getId() + "_" + showId + "_episodeguide", epListXml);
            }
            LOGGER.trace("******** BEGIN EPISODE LIST XML ***********");
            LOGGER.trace(epListXml);
            LOGGER.trace("******** END EPISODE LIST XML ***********");
            Document epListDoc = this.parseXmlString(epListXml);
            NodeList nl = epListDoc.getElementsByTagName("episode");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                int season = DOMUtils.getElementIntValue(el, "season");
                int ep = DOMUtils.getElementIntValue(el, "epnum");
                String epXml = this.elementToString(el);
                if (epXml != null) {
                    KodiMetadataProvider.XML_CACHE.put(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(season) + "_E" + this.lz(ep), epXml);
                }
                MediaMetadata md = new MediaMetadata(this.scraper.getProviderInfo().getId());
                md.setEpisodeNumber(ep);
                md.setSeasonNumber(season);
                md.setTitle(DOMUtils.getElementValue(el, "title"));
                md.setId(this.scraper.getProviderInfo().getId(), DOMUtils.getElementValue(el, "id"));
                try {
                    md.setReleaseDate(StrgUtils.parseDate(DOMUtils.getElementValue(el, "aired")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                episodeList.add(md);
            }
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: " + e.getMessage());
            throw new ScrapeException(e);
        }
        if (episodeList.isEmpty()) {
            LOGGER.warn("Could not find episodes - did you scrape the show recently?");
        }
        return episodeList;
    }

    @Override
    public List<IMediaProvider> getPluginsForType(MediaType type) {
        return null;
    }

    @Override
    public IMediaProvider getPluginById(String id) {
        return null;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.trace("getArtwork(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaArtwork> mas = new ArrayList<MediaArtwork>();
        try {
            if (options.getSearchResult() == null || !this.scraper.getProviderInfo().getId().equals(options.getSearchResult().getProviderId())) {
                throw new MissingIdException(new String[]{"scraping with Kodi scrapers only with a prior result possible"});
            }
            MediaMetadata md = this._getMetadata(options);
            mas.addAll(md.getMediaArt(options.getArtworkType()));
            LOGGER.trace("******* END ARTWORK XML FOR {} ***********", (Object)options.getArtworkType());
        }
        catch (Exception e) {
            LOGGER.error("error getting artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        return mas;
    }
}

