/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.entities.DiscArt;
import org.tinymediamanager.scraper.mpdbtv.entities.Fanart;
import org.tinymediamanager.scraper.mpdbtv.entities.HDClearArt;
import org.tinymediamanager.scraper.mpdbtv.entities.HDLogo;
import org.tinymediamanager.scraper.mpdbtv.entities.MovieEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Poster;
import org.tinymediamanager.scraper.mpdbtv.services.Controller;
import org.tinymediamanager.scraper.util.ListUtils;
import retrofit2.Response;

public class MpdbMovieArtworkMetadataProvider
extends MpdbMetadataProvider
implements IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpdbMovieArtworkMetadataProvider.class);
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    public MpdbMovieArtworkMetadataProvider() {
        this.controller = new Controller(false);
    }

    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        MediaArtwork mediaArtwork;
        this.initAPI();
        MovieEntity scrapeResult = null;
        ArrayList<MediaArtwork> ma = new ArrayList<MediaArtwork>();
        String id = options.getIdAsString(this.providerInfo.getId());
        if ("0".equals(id)) {
            LOGGER.debug("Cannot get artwork - no mpdb id set");
            throw new MissingIdException(new String[]{this.getId()});
        }
        LOGGER.info("========= BEGIN MPDB.tv artwork scraping");
        try {
            Response<MovieEntity> response = this.controller.getScrapeInformation(this.getEncodedUserName(), this.getSubscriptionKey(), id, null, null, "json");
            if (response.isSuccessful()) {
                scrapeResult = (MovieEntity)response.body();
            }
        }
        catch (HttpException e) {
            LOGGER.debug("nothing found");
            if (e.getStatusCode() == 404) {
                return Collections.emptyList();
            }
            throw new ScrapeException(e);
        }
        catch (Exception e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (scrapeResult == null) {
            LOGGER.warn("no result from MPDB.tv");
            return Collections.emptyList();
        }
        for (Poster poster : ListUtils.nullSafe(scrapeResult.posters)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            mediaArtwork.setPreviewUrl(poster.preview);
            mediaArtwork.setDefaultUrl(poster.original);
            mediaArtwork.setOriginalUrl(poster.original);
            mediaArtwork.setLikes(poster.votes);
            ma.add(mediaArtwork);
        }
        for (Fanart fanart : ListUtils.nullSafe(scrapeResult.fanarts)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            mediaArtwork.setPreviewUrl(fanart.preview);
            mediaArtwork.setDefaultUrl(fanart.original);
            mediaArtwork.setOriginalUrl(fanart.original);
            mediaArtwork.setLikes(fanart.votes);
            ma.add(mediaArtwork);
        }
        for (DiscArt discArt : ListUtils.nullSafe(scrapeResult.discarts)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.DISC);
            mediaArtwork.setPreviewUrl(discArt.preview);
            mediaArtwork.setDefaultUrl(discArt.original);
            mediaArtwork.setOriginalUrl(discArt.original);
            mediaArtwork.setLikes(discArt.votes);
            ma.add(mediaArtwork);
        }
        for (HDClearArt hdClearArt : ListUtils.nullSafe(scrapeResult.hdcleararts)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARART);
            mediaArtwork.setPreviewUrl(hdClearArt.preview);
            mediaArtwork.setDefaultUrl(hdClearArt.original);
            mediaArtwork.setOriginalUrl(hdClearArt.original);
            mediaArtwork.setLikes(hdClearArt.votes);
            ma.add(mediaArtwork);
        }
        for (HDLogo hdLogo : ListUtils.nullSafe(scrapeResult.hdlogos)) {
            mediaArtwork = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARLOGO);
            mediaArtwork.setPreviewUrl(hdLogo.preview);
            mediaArtwork.setDefaultUrl(hdLogo.original);
            mediaArtwork.setOriginalUrl(hdLogo.original);
            mediaArtwork.setLikes(hdLogo.votes);
            ma.add(mediaArtwork);
        }
        return ma;
    }
}

