/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.mpdbtv.entities.MovieEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.SearchEntity;
import org.tinymediamanager.scraper.mpdbtv.services.MpdbService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private final Retrofit retrofit;
    private String apiKey;

    public Controller() {
        this(false);
    }

    public Controller(boolean debug) {
        OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
        if (debug) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
        builder.addInterceptor(chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            if (response.code() != 200) {
                throw new HttpException(response.code(), response.message());
            }
            return response;
        });
        this.retrofit = this.buildRetrofitInstance(builder.build());
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    public retrofit2.Response<List<SearchEntity>> getSearchInformation(String username, String subscriptionkey, String searchstring, Locale language, boolean saga, String format) throws IOException {
        return this.getService().movieSearch(this.apiKey, username, subscriptionkey, searchstring, language, saga, format).execute();
    }

    public retrofit2.Response<MovieEntity> getScrapeInformation(String username, String subscriptionkey, String id, Locale language, String typeId, String format) throws IOException {
        return this.getService().movieScrapebyID(this.apiKey, username, subscriptionkey, id, language, typeId, format).execute();
    }

    private MpdbService getService() {
        return (MpdbService)this.retrofit.create(MpdbService.class);
    }

    private Retrofit buildRetrofitInstance(OkHttpClient client) {
        return new Retrofit.Builder().client(client).baseUrl("http://mpdb.tv/api/v1/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).build();
    }
}

