/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ofdb;

import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;

abstract class OfdbMetadataProvider
implements IMediaProvider {
    static final String ID = "ofdb";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    OfdbMetadataProvider() {
    }

    protected abstract String getSubId();

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    private MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), "Online Filmdatenbank (OFDb.de)", "<html><h3>Online Filmdatenbank (OFDb)</h3><br />A german movie database driven by the community.<br /><br />Available languages: DE</html>", OfdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/ofdb_de.svg"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    protected String cleanSearch(String q) {
        q = " " + MetadataUtil.removeNonSearchCharacters((String)q) + " ";
        q = ((String)q).replaceAll("(?i)( a | the | der | die | das |\\(\\d+\\))", " ");
        q = ((String)q).replaceAll("[^A-Za-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc ]", " ");
        q = ((String)q).replace("  ", "");
        return ((String)q).trim();
    }
}

