/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.opensubtitles.OpenSubtitlesConnectionCounter;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcClient;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcException;
import org.tinymediamanager.scraper.opensubtitles.model.Info;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.Similarity;

abstract class OpenSubtitlesSubtitleProvider
implements IMediaProvider {
    public static final String ID = "opensubtitles";
    private static final String SERVICE = "http://api.opensubtitles.org/xml-rpc";
    private static final int HASH_CHUNK_SIZE = 65536;
    protected static TmmXmlRpcClient client = null;
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    private String sessionToken = "";
    private String username = "";
    private String password = "";

    protected OpenSubtitlesSubtitleProvider() {
    }

    protected abstract String getSubId();

    protected abstract Logger getLogger();

    private MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "OpenSubtitles.org", "<html><h3>OpenSubtitles.org</h3><br />A subtitle scraper for OpenSubtitles.org</html>", OpenSubtitlesSubtitleProvider.class.getResource("/org/tinymediamanager/scraper/opensubtitles_org.png"));
        info.getConfig().addText("username", "");
        info.getConfig().addText("password", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    private synchronized void initAPI() throws ScrapeException {
        if (client == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                client = new TmmXmlRpcClient(new URL(SERVICE));
            }
            catch (MalformedURLException e) {
                this.getLogger().error("cannot create XmlRpcClient", (Throwable)e);
                throw new ScrapeException(e);
            }
        }
        try {
            client.setUserAgent(this.getApiKey());
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    public List<SubtitleSearchResult> search(SubtitleSearchAndScrapeOptions options) throws ScrapeException {
        Info info;
        HashMap<String, String> mapQuery;
        this.initAPI();
        ArrayList<SubtitleSearchResult> results = new ArrayList<SubtitleSearchResult>();
        if (options.getFile() != null && options.getFile().exists() && options.getFile().length() > 0L) {
            File file = options.getFile();
            long fileSize = file.length();
            String hash = this.computeOpenSubtitlesHash(file);
            this.getLogger().debug("searching subtitle for {}", (Object)file);
            this.getLogger().debug("moviebytesize: {}; moviehash: {}", (Object)fileSize, (Object)hash);
            HashMap<String, String> mapQuery2 = new HashMap<String, String>();
            mapQuery2.put("moviebytesize", String.valueOf(fileSize));
            mapQuery2.put("moviehash", hash);
            mapQuery2.put("sublanguageid", this.getLanguageCode(options.getLanguage().toLocale()));
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Object[] arrayQuery = new Object[]{mapQuery2};
                Info info2 = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info2.getMovieInfo()) {
                    SubtitleSearchResult result = this.morphSearchResult(movieInfo);
                    result.setScore(1.0f);
                    results.add(result);
                }
                this.getLogger().debug("found {} results", (Object)info2.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException(new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException(new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                }
                throw new ScrapeException(e.getCause());
            }
            catch (Exception e) {
                this.getLogger().error("Could not search subtitle - {}", (Object)e.getMessage());
            }
        }
        if (results.isEmpty() && MetadataUtil.isValidImdbId(options.getImdbId())) {
            mapQuery = new HashMap<String, String>();
            this.getLogger().debug("searching subtitle for imdb id: {}", (Object)options.getImdbId());
            mapQuery.put("imdbid", options.getImdbId().replace("tt", ""));
            mapQuery.put("sublanguageid", this.getLanguageCode(options.getLanguage().toLocale()));
            if (options.getEpisode() > -1) {
                mapQuery.put("episode", String.valueOf(options.getEpisode()));
            }
            if (options.getSeason() > -1) {
                mapQuery.put("season", String.valueOf(options.getSeason()));
            }
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Object[] arrayQuery = new Object[]{mapQuery};
                info = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info.getMovieInfo()) {
                    SubtitleSearchResult result = this.morphSearchResult(movieInfo);
                    result.setScore(0.9f);
                    results.add(result);
                }
                this.getLogger().debug("found {} results", (Object)info.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException(new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException(new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                    case 503: {
                        throw new ScrapeException(new HttpException(503, "Service unavailable (HTTP 503))"));
                    }
                }
                throw new ScrapeException(e.getCause());
            }
            catch (Exception e) {
                this.getLogger().error("Could not search subtitle.", (Throwable)e);
            }
        }
        if (results.isEmpty() && StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
            mapQuery = new HashMap();
            this.getLogger().debug("serching subtitle for query: {}", (Object)options.getSearchQuery());
            mapQuery.put("query", options.getSearchQuery());
            mapQuery.put("sublanguageid", this.getLanguageCode(options.getLanguage().toLocale()));
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Object[] arrayQuery = new Object[]{mapQuery};
                info = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info.getMovieInfo()) {
                    float score = 0.8f * Similarity.compareStrings(options.getSearchQuery(), movieInfo.movieTitle);
                    SubtitleSearchResult result = this.morphSearchResult(movieInfo);
                    result.setScore(score);
                    results.add(result);
                }
                this.getLogger().debug("found {} results", (Object)info.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException(new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException(new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                }
                throw new ScrapeException((Throwable)((Object)e));
            }
            catch (Exception e) {
                this.getLogger().error("Could not search subtitle.", (Throwable)e);
            }
        }
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private SubtitleSearchResult morphSearchResult(Info.MovieInfo movieInfo) {
        SubtitleSearchResult result = new SubtitleSearchResult(this.providerInfo.getId());
        result.setId(movieInfo.id);
        result.setTitle(movieInfo.movieTitle);
        result.setReleaseName(movieInfo.movieReleaseName);
        result.setUrl(movieInfo.zipDownloadLink);
        result.setRating(movieInfo.subRating.floatValue());
        result.setStackCount(movieInfo.subSumCD);
        result.setScore((float)movieInfo.score);
        return result;
    }

    private Object methodCall(String method, Object params) throws TmmXmlRpcException, ScrapeException {
        this.startSession();
        Object response = null;
        if (StringUtils.isNotBlank((CharSequence)this.sessionToken)) {
            response = params != null ? client.call(method, this.sessionToken, params) : client.call(method, this.sessionToken);
        } else {
            this.getLogger().warn("Have no session - seems the startSession() did not work successfully");
        }
        return response;
    }

    private String getLanguageCode(Locale locale) {
        String languageCode = LanguageUtils.getIso3BLanguage(locale.getLanguage());
        if ("gre".equals(languageCode)) {
            languageCode = "ell";
        }
        if ("pt_BR".equalsIgnoreCase(locale.toString())) {
            languageCode = "pob";
        }
        return languageCode;
    }

    private synchronized void startSession() throws ScrapeException {
        if (this.providerInfo.getConfig().getValue("username") != null && !this.username.equals(this.providerInfo.getConfig().getValue("username")) || this.providerInfo.getConfig().getValue("password") != null && !this.password.equals(this.providerInfo.getConfig().getValue("password"))) {
            this.username = this.providerInfo.getConfig().getValue("username");
            this.password = this.providerInfo.getConfig().getValue("password");
            this.sessionToken = "";
        }
        if (StringUtils.isBlank((CharSequence)this.sessionToken)) {
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Map response = (Map)client.call("LogIn", this.username, this.password, "", this.getApiKey());
                this.sessionToken = (String)response.get("token");
                this.getLogger().debug("Login OK");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String computeOpenSubtitlesHash(File file) {
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        try (FileInputStream is = new FileInputStream(file);){
            String string;
            block13: {
                FileChannel fileChannel = is.getChannel();
                try {
                    ByteBuffer buf = ByteBuffer.allocate((int)chunkSizeForFile);
                    fileChannel.read(buf);
                    long head = OpenSubtitlesSubtitleProvider.computeOpenSubtitlesHashForChunk(buf);
                    fileChannel.read(buf, Math.max(size - 65536L, 0L));
                    long tail = OpenSubtitlesSubtitleProvider.computeOpenSubtitlesHashForChunk(buf);
                    string = String.format("%016x", size + head + tail);
                    if (fileChannel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileChannel.close();
            }
            return string;
        }
        catch (Exception e) {
            this.getLogger().error("Error computing OpenSubtitles hash", (Throwable)e);
            return "";
        }
    }

    private static long computeOpenSubtitlesHashForChunk(ByteBuffer buffer) {
        buffer.rewind();
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

