/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Info {
    private final double seconds;
    private final String status;
    private final List<MovieInfo> movieInfo = new ArrayList<MovieInfo>();

    public Info(Map<String, Object> response) throws Exception {
        this.seconds = (Double)response.get("seconds");
        this.status = (String)response.get("status");
        Object[] data = (Object[])response.get("data");
        if (data != null) {
            for (Object datum : data) {
                this.movieInfo.add(new MovieInfo(datum));
            }
        }
    }

    public List<MovieInfo> getMovieInfo() {
        return this.movieInfo;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class MovieInfo {
        public final String id;
        public final String movieHash;
        public final double score;
        public final String movieKind;
        public final String movieTitle;
        public final String movieReleaseName;
        public final String subFormat;
        public final String subDownloadLink;
        public final int subSumCD;
        public final Float subRating;
        public final String zipDownloadLink;
        public final String season;
        public final String episode;

        public MovieInfo(Object data) throws Exception {
            Map values = (Map)data;
            this.id = (String)values.get("IDSubtitleFile");
            this.movieHash = (String)values.get("MovieHash");
            this.score = (Double)values.get("Score");
            this.movieKind = (String)values.get("MovieKind");
            this.movieTitle = (String)values.get("MovieName");
            this.movieReleaseName = (String)values.get("MovieReleaseName");
            this.subFormat = (String)values.get("SubFormat");
            this.subDownloadLink = (String)values.get("SubDownloadLink");
            this.subSumCD = Integer.parseInt((String)values.get("SubSumCD"));
            this.subRating = Float.valueOf(Float.parseFloat((String)values.get("SubRating")));
            this.zipDownloadLink = (String)values.get("ZipDownloadLink");
            this.season = (String)values.get("SeriesSeason");
            this.episode = (String)values.get("SeriesEpisode");
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

