/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.CompanyBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ContentRating;
import org.tinymediamanager.scraper.thetvdb.entities.GenreBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.MovieExtendedRecord;
import org.tinymediamanager.scraper.thetvdb.entities.MovieExtendedResponse;
import org.tinymediamanager.scraper.thetvdb.entities.Release;
import org.tinymediamanager.scraper.thetvdb.entities.RemoteID;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SearchType;
import org.tinymediamanager.scraper.thetvdb.entities.Translation;
import org.tinymediamanager.scraper.thetvdb.entities.TranslationResponse;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.RatingUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import retrofit2.Response;

public class TheTvDbMovieMetadataProvider
extends TheTvDbMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMovieMetadataProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.values()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        info.getConfig().addSelect("fallbackLanguage", fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        List<SearchResultRecord> searchResults;
        TreeSet<MediaSearchResult> results;
        block26: {
            int tvdbId;
            this.initAPI();
            LOGGER.debug("search() {}", (Object)options);
            results = new TreeSet<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if ((tvdbId = options.getIdAsInt(this.getId())) != 0) {
                LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
                try {
                    MediaMetadata md = this.getMetadata(options);
                    if (md != null) {
                        results.add(this.morphMediaMetadataToSearchResult(md, MediaType.MOVIE));
                        return results;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                }
            }
            searchResults = null;
            if (StringUtils.isNotBlank((CharSequence)searchString)) {
                try {
                    Response httpResponse = this.tvdb.getSearchService().getSearch(searchString, SearchType.MOVIE).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    searchResults = ((SearchResultResponse)httpResponse.body()).data;
                    if (!ListUtils.isEmpty(searchResults) || !ID_PATTERN.matcher(searchString).matches()) break block26;
                    LOGGER.debug("nothing found, but search term '{}' looks like a TvDb ID - getting direct", (Object)searchString);
                    try {
                        MediaMetadata md = this.getMetadata(options);
                        if (md != null) {
                            results.add(this.morphMediaMetadataToSearchResult(md, MediaType.MOVIE));
                            return results;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
            }
        }
        if (ListUtils.isEmpty(searchResults)) {
            return results;
        }
        HashMap<String, MediaSearchResult> resultMap = new HashMap<String, MediaSearchResult>();
        for (SearchResultRecord searchResultRecord : searchResults) {
            String title;
            MediaSearchResult result = new MediaSearchResult(this.getId(), options.getMediaType());
            String id = "";
            if (StringUtils.isNotBlank((CharSequence)searchResultRecord.tvdbId)) {
                id = searchResultRecord.tvdbId;
            } else if (StringUtils.isNotBlank((CharSequence)searchResultRecord.id)) {
                id = searchResultRecord.id.replace("movie-", "");
            }
            if (StringUtils.isBlank((CharSequence)id)) continue;
            result.setId(id);
            MediaLanguages baseLanguage = options.getLanguage();
            MediaLanguages fallbackLanguage = null;
            if (StringUtils.isNotBlank((CharSequence)this.getProviderInfo().getConfig().getValue("fallbackLanguage"))) {
                fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage"));
            }
            if (StringUtils.isNotBlank((CharSequence)(title = this.parseLocalizedText(baseLanguage, searchResultRecord.translations)))) {
                result.setTitle(title);
            } else {
                title = this.parseLocalizedText(fallbackLanguage, searchResultRecord.translations);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    result.setTitle(title);
                } else {
                    result.setTitle(searchResultRecord.name);
                }
            }
            String overview = this.parseLocalizedText(baseLanguage, searchResultRecord.overviews);
            if (StringUtils.isNotBlank((CharSequence)overview)) {
                result.setOverview(overview);
            } else {
                overview = this.parseLocalizedText(fallbackLanguage, searchResultRecord.overviews);
                if (StringUtils.isNotBlank((CharSequence)overview)) {
                    result.setOverview(overview);
                } else {
                    result.setOverview(searchResultRecord.overview);
                }
            }
            result.setYear(MetadataUtil.parseInt(searchResultRecord.year, 0));
            result.setPosterUrl(searchResultRecord.imageUrl);
            result.calculateScore(options);
            resultMap.put(id, result);
        }
        results.addAll(resultMap.values());
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        MediaRating imdbRating;
        MovieExtendedRecord movie;
        this.initAPI();
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata(this.getId());
        Integer id = options.getIdAsInteger(this.getId());
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        Translation baseTranslation = null;
        Translation fallbackTranslation = null;
        try {
            Response translationResponse;
            Object httpResponse;
            String baseLanguage = LanguageUtils.getIso3Language(options.getLanguage().toLocale());
            String fallbackLanguage = LanguageUtils.getIso3Language(MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).toLocale());
            if ("pob".equals(baseLanguage)) {
                baseLanguage = "pt";
            }
            if ("pob".equals(fallbackLanguage)) {
                fallbackLanguage = "pt";
            }
            if (!(httpResponse = this.tvdb.getMoviesService().getMovieExtended(id.intValue()).execute()).isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            movie = ((MovieExtendedResponse)httpResponse.body()).data;
            if (movie.overviewTranslations.contains(baseLanguage) && (translationResponse = this.tvdb.getMoviesService().getMoviesTranslation(id.intValue(), baseLanguage).execute()).isSuccessful()) {
                baseTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
            if ((baseTranslation == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{baseTranslation.name, baseTranslation.overview})) && movie.overviewTranslations.contains(fallbackLanguage) && (translationResponse = this.tvdb.getMoviesService().getMoviesTranslation(id.intValue(), fallbackLanguage).execute()).isSuccessful()) {
                fallbackTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            throw new NothingFoundException();
        }
        md.setId(this.getId(), movie.id);
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.name)) {
            md.setTitle(baseTranslation.name);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setTitle(fallbackTranslation.name);
        } else {
            md.setTitle(movie.name);
        }
        md.setOriginalTitle(movie.name);
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.overview)) {
            md.setPlot(baseTranslation.overview);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setPlot(fallbackTranslation.overview);
        }
        for (RemoteID remoteID : ListUtils.nullSafe(movie.remoteIds)) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{remoteID.sourceName, remoteID.id})) continue;
            switch (remoteID.sourceName) {
                case "IMDB": {
                    if (!MetadataUtil.isValidImdbId(remoteID.id)) break;
                    md.setId("imdb", remoteID.id);
                    break;
                }
                case "Zap2It": {
                    md.setId("zap2it", remoteID.id);
                    break;
                }
                case "TheMovieDB.com": {
                    md.setId("tmdb", MetadataUtil.parseInt(remoteID.id, 0));
                    break;
                }
            }
        }
        Date localReleaseDate = null;
        Date globalReleaseDate = null;
        for (Release release : ListUtils.nullSafe(movie.releases)) {
            try {
                Date date = StrgUtils.parseDate(release.date);
                if ("global".equalsIgnoreCase(release.country)) {
                    globalReleaseDate = date;
                }
                if (!options.getReleaseDateCountry().equals(release.country)) continue;
                localReleaseDate = date;
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse release date - '{}'", (Object)e.getMessage());
            }
        }
        Date releaseDate = null;
        if (localReleaseDate != null) {
            releaseDate = localReleaseDate;
        } else if (globalReleaseDate != null) {
            releaseDate = globalReleaseDate;
        }
        if (releaseDate != null) {
            md.setReleaseDate(releaseDate);
        }
        if (globalReleaseDate != null) {
            Iterator<Object> calendar = Calendar.getInstance();
            ((Calendar)((Object)calendar)).setTime(globalReleaseDate);
            int y = ((Calendar)((Object)calendar)).get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                md.setTitle(this.clearYearFromTitle(md.getTitle(), y));
            }
        }
        md.setRuntime(MetadataUtil.unboxInteger(movie.runtime, 0));
        if (movie.companies != null) {
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.production)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.studio)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.network)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.specialEffects)) {
                md.addProductionCompany(baseRecord.name);
            }
            for (CompanyBaseRecord baseRecord : ListUtils.nullSafe(movie.companies.distributor)) {
                md.addProductionCompany(baseRecord.name);
            }
        }
        for (Person member : this.parseCastMembers(movie.characters)) {
            md.addCastMember(member);
        }
        for (GenreBaseRecord genreBaseRecord : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(MediaGenres.getGenre(genreBaseRecord.name));
        }
        for (ArtworkBaseRecord artworkBaseRecord : ListUtils.nullSafe(movie.artworks)) {
            MediaArtwork mediaArtwork = this.parseArtwork(artworkBaseRecord);
            if (mediaArtwork == null) continue;
            md.addMediaArt(mediaArtwork);
        }
        for (ContentRating contentRating : ListUtils.nullSafe(movie.contentRatings)) {
            MediaCertification certification = MediaCertification.findCertification(contentRating.name);
            if (certification == null || certification == MediaCertification.UNKNOWN) continue;
            md.addCertification(certification);
        }
        if (md.getId("imdb") instanceof String && (imdbRating = RatingUtil.getImdbRating((String)md.getId("imdb"))) != null) {
            md.addRating(imdbRating);
        }
        return md;
    }
}

