/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbTvShowMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesExtendedResponse;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import retrofit2.Response;

public class TheTvDbTvShowArtworkProvider
extends TheTvDbMetadataProvider
implements ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbTvShowArtworkProvider.class);

    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        LOGGER.debug("getting artwork: {}", (Object)options);
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        if (options.getMediaType() == MediaType.TV_EPISODE) {
            try {
                TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
                episodeSearchAndScrapeOptions.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    episodeSearchAndScrapeOptions.setTvShowIds(tvShowIds);
                }
                MediaMetadata md = new TheTvDbTvShowMetadataProvider().getMetadata(episodeSearchAndScrapeOptions);
                return md.getMediaArt();
            }
            catch (MissingIdException e) {
                return Collections.emptyList();
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
        Integer id = options.getIdAsInteger(this.getProviderInfo().getId());
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getProviderInfo().getId()});
        }
        ArrayList<ArtworkBaseRecord> images = new ArrayList<ArtworkBaseRecord>();
        try {
            Response response = this.tvdb.getSeriesService().getSeriesExtended(id.intValue()).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.code(), response.message());
            }
            if (response.body() != null && ((SeriesExtendedResponse)response.body()).data != null && ((SeriesExtendedResponse)response.body()).data.artworks != null) {
                images.addAll(((SeriesExtendedResponse)response.body()).data.artworks);
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (ListUtils.isEmpty(images)) {
            return artwork;
        }
        images.sort(new ImageComparator(LanguageUtils.getIso3Language(options.getLanguage().toLocale())));
        for (ArtworkBaseRecord image : images) {
            MediaArtwork ma = this.parseArtwork(image);
            if (ma == null || options.getArtworkType() != MediaArtwork.MediaArtworkType.ALL && options.getArtworkType() != ma.getType()) continue;
            artwork.add(ma);
        }
        return artwork;
    }

    private static class ImageComparator
    implements Comparator<ArtworkBaseRecord> {
        private final String preferredLangu;
        private final String english;

        private ImageComparator(String language) {
            this.preferredLangu = language;
            this.english = "eng";
        }

        @Override
        public int compare(ArtworkBaseRecord arg0, ArtworkBaseRecord arg1) {
            if (this.preferredLangu.equals(arg0.language) && !this.preferredLangu.equals(arg1.language)) {
                return -1;
            }
            if (!this.preferredLangu.equals(arg0.language) && this.preferredLangu.equals(arg1.language)) {
                return 1;
            }
            if (this.english.equals(arg0.language) && !this.english.equals(arg1.language)) {
                return -1;
            }
            if (!this.english.equals(arg0.language) && this.english.equals(arg1.language)) {
                return 1;
            }
            int result = 0;
            if (arg0.score != null && arg1.score != null) {
                result = Long.compare(arg1.score.intValue(), arg0.score.intValue());
            }
            if (result == 0) {
                result = Long.compare(arg0.id.intValue(), arg1.id.intValue());
            }
            return result;
        }
    }
}

