/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.util.Date;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.thetvdb.entities.LoginRequestRecord;
import org.tinymediamanager.scraper.thetvdb.entities.LoginResponse;
import org.tinymediamanager.scraper.thetvdb.service.ConfigService;
import org.tinymediamanager.scraper.thetvdb.service.EpisodesService;
import org.tinymediamanager.scraper.thetvdb.service.LoginService;
import org.tinymediamanager.scraper.thetvdb.service.MoviesService;
import org.tinymediamanager.scraper.thetvdb.service.SearchService;
import org.tinymediamanager.scraper.thetvdb.service.SeasonsService;
import org.tinymediamanager.scraper.thetvdb.service.SeriesService;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private static final String API_BASE_URL = "https://api4.thetvdb.com/v4/";
    private final boolean debug;
    private Retrofit restAdapter;
    private String authToken;

    public Controller() {
        this(false);
    }

    public Controller(boolean debug) {
        this.debug = debug;
    }

    private Retrofit getRestAdapter() {
        if (this.restAdapter == null) {
            OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
            if (this.debug) {
                builder.addInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)LOGGER).debug(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY));
            }
            builder.addInterceptor(chain -> {
                Request original = chain.request();
                Request.Builder request = original.newBuilder().method(original.method(), original.body());
                request.addHeader("Authorization", "Bearer " + this.authToken);
                return chain.proceed(request.build());
            });
            this.restAdapter = new Retrofit.Builder().client(builder.build()).baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)Controller.getGsonBuilder().create())).build();
        }
        return this.restAdapter;
    }

    private static GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return -1;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    public static String login(String apiKey) throws Exception {
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            return null;
        }
        OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
        Retrofit retrofit = new Retrofit.Builder().client(builder.build()).baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)Controller.getGsonBuilder().create())).build();
        LoginService loginService = (LoginService)retrofit.create(LoginService.class);
        LoginRequestRecord data = new LoginRequestRecord();
        data.apikey = apiKey;
        data.pin = "";
        Response response = loginService.login(data).execute();
        String token = null;
        if (response.isSuccessful()) {
            token = ((LoginResponse)response.body()).data.token;
        }
        if (StringUtils.isBlank(token)) {
            throw new HttpException(403, "Unauthorized");
        }
        return token;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public ConfigService getConfigService() {
        return (ConfigService)this.getRestAdapter().create(ConfigService.class);
    }

    public SearchService getSearchService() {
        return (SearchService)this.getRestAdapter().create(SearchService.class);
    }

    public SeriesService getSeriesService() {
        return (SeriesService)this.getRestAdapter().create(SeriesService.class);
    }

    public EpisodesService getEpisodesService() {
        return (EpisodesService)this.getRestAdapter().create(EpisodesService.class);
    }

    public SeasonsService getSeasonsService() {
        return (SeasonsService)this.getRestAdapter().create(SeasonsService.class);
    }

    public MoviesService getMoviesService() {
        return (MoviesService)this.getRestAdapter().create(MoviesService.class);
    }
}

