/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.tinymediamanager.scraper.tmdb.TmdbController;

public class TmdbInterceptor
implements Interceptor {
    private final TmdbController tmdbController;

    public TmdbInterceptor(TmdbController tmdbController) {
        this.tmdbController = tmdbController;
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        return TmdbInterceptor.handleIntercept(chain, this.tmdbController);
    }

    public static Response handleIntercept(Interceptor.Chain chain, TmdbController tmdbController) throws IOException {
        String retryHeader;
        Request request = chain.request();
        if (!"api.themoviedb.org".equals(request.url().host())) {
            return chain.proceed(request);
        }
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        urlBuilder.setEncodedQueryParameter("api_key", tmdbController.apiKey());
        Request.Builder builder = request.newBuilder();
        builder.url(urlBuilder.build());
        Response response = chain.proceed(builder.build());
        if (!response.isSuccessful() && (retryHeader = response.header("Retry-After")) != null) {
            try {
                int retry = Integer.parseInt(retryHeader);
                Thread.sleep((int)(((double)retry + 0.5) * 1000.0));
                if (response.body() != null) {
                    response.body().close();
                }
                return TmdbInterceptor.handleIntercept(chain, tmdbController);
            }
            catch (InterruptedException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return response;
    }
}

