/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTmdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbUtils;
import org.tinymediamanager.scraper.tmdb.entities.AppendToResponse;
import org.tinymediamanager.scraper.tmdb.entities.BaseCompany;
import org.tinymediamanager.scraper.tmdb.entities.BaseKeyword;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvEpisode;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvShow;
import org.tinymediamanager.scraper.tmdb.entities.CastMember;
import org.tinymediamanager.scraper.tmdb.entities.ContentRating;
import org.tinymediamanager.scraper.tmdb.entities.CrewMember;
import org.tinymediamanager.scraper.tmdb.entities.FindResults;
import org.tinymediamanager.scraper.tmdb.entities.Genre;
import org.tinymediamanager.scraper.tmdb.entities.Image;
import org.tinymediamanager.scraper.tmdb.entities.Network;
import org.tinymediamanager.scraper.tmdb.entities.TvEpisode;
import org.tinymediamanager.scraper.tmdb.entities.TvSeason;
import org.tinymediamanager.scraper.tmdb.entities.TvShow;
import org.tinymediamanager.scraper.tmdb.entities.TvShowResultsPage;
import org.tinymediamanager.scraper.tmdb.enumerations.AppendToResponseItem;
import org.tinymediamanager.scraper.tmdb.enumerations.ExternalSource;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.RatingUtil;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

public class TmdbTvShowMetadataProvider
extends TmdbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowTmdbMetadataProvider,
ITvShowImdbMetadataProvider,
ITvShowTvdbMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(600L, 5L);
    private static final CacheMap<Integer, String> ORIGINAL_LANGUAGE_CACHE_MAP = new CacheMap(600L, 5L);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addBoolean("includeAdultShows", false);
        info.getConfig().addBoolean("scrapeLanguageNames", true);
        info.getConfig().addBoolean("titleFallback", false);
        info.getConfig().addSelect("titleFallbackLanguage", PT, "en-US");
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Response httpResponse;
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        Exception savedException = null;
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = Utils.removeSortableName(options.getSearchQuery());
        }
        searchString = MetadataUtil.removeNonSearchCharacters(searchString);
        String imdbId = options.getImdbId();
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = "";
        }
        if (MetadataUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        int tvdbId = options.getIdAsInt("tvdb");
        boolean adult = this.getProviderInfo().getConfig().getValueAsBool("includeAdultShows");
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.info("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        if (tmdbId != 0) {
            LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
            try {
                httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Iterator<BaseTvShow> show = (TvShow)httpResponse.body();
                this.injectTranslations(Locale.forLanguageTag(language), (TvShow)((Object)show));
                results.add(this.morphTvShowToSearchResult((BaseTvShow)((Object)show), options));
                LOGGER.debug("found {} results with TMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
            try {
                httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                    this.injectTranslations(Locale.forLanguageTag(language), show);
                    results.add(this.morphTvShowToSearchResult(show, options));
                }
                LOGGER.debug("found {} results with IMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && tvdbId > 0) {
            LOGGER.debug("found TVDB ID {} - getting direct", (Object)tvdbId);
            try {
                httpResponse = this.api.findService().find(tvdbId, ExternalSource.TVDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                    this.injectTranslations(options.getLanguage().toLocale(), show);
                    results.add(this.morphTvShowToSearchResult(show, options));
                }
                LOGGER.debug("found {} results with TVDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tvdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty()) {
            try {
                Response httpResponse2;
                int page = 1;
                int maxPage = 1;
                do {
                    if (!(httpResponse2 = this.api.searchService().tv(searchString, page, language, null, adult).execute()).isSuccessful() || httpResponse2.body() == null) {
                        throw new HttpException(httpResponse2.code(), httpResponse2.message());
                    }
                    for (BaseTvShow show : ListUtils.nullSafe(((TvShowResultsPage)httpResponse2.body()).results)) {
                        this.injectTranslations(Locale.forLanguageTag(language), show);
                        results.add(this.morphTvShowToSearchResult(show, options));
                    }
                } while (++page <= (maxPage = ((TvShowResultsPage)httpResponse2.body()).total_pages.intValue()));
                LOGGER.debug("found {} results with search string", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && savedException != null) {
            throw new ScrapeException(savedException);
        }
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList(): {} ", (Object)options);
        this.initAPI();
        int tmdbId = options.getTmdbId();
        if (MetadataUtil.isValidImdbId(options.getImdbId())) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, options.getImdbId());
            }
            catch (Exception e) {
                LOGGER.warn("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, options.getIdAsInteger("tvdb"));
            }
            catch (Exception e) {
                LOGGER.warn("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            throw new MissingIdException(new String[]{"tmdb"});
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(tmdbId + "_" + language);
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        episodes = new ArrayList<MediaMetadata>();
        try {
            Response showResponse = this.api.tvService().tv(tmdbId, language).execute();
            if (!showResponse.isSuccessful()) {
                throw new HttpException(showResponse.code(), showResponse.message());
            }
            for (TvSeason season : ListUtils.nullSafe(((TvShow)showResponse.body()).seasons)) {
                ArrayList<MediaMetadata> seasonEpisodes = new ArrayList<MediaMetadata>();
                Response seasonResponse = this.api.tvSeasonsService().season(tmdbId, season.season_number, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!seasonResponse.isSuccessful()) {
                    throw new HttpException(seasonResponse.code(), seasonResponse.message());
                }
                for (TvEpisode episode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                    seasonEpisodes.add(this.morphTvEpisodeToMediaMetadata(episode));
                }
                episodes.addAll(seasonEpisodes);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(tmdbId + "_" + language, episodes);
        }
        return episodes;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        MediaRating imdbRating;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0 && MetadataUtil.isValidImdbId(options.getImdbId())) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, options.getImdbId());
            }
            catch (Exception e) {
                LOGGER.warn("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, options.getIdAsInteger("tvdb"));
            }
            catch (Exception e) {
                LOGGER.warn("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        TvShow complete = null;
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS, AppendToResponseItem.KEYWORDS)).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            complete = (TvShow)httpResponse.body();
            this.injectTranslations(Locale.forLanguageTag(language), complete);
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        md.setId(this.getId(), tmdbId);
        md.setTitle(complete.name);
        md.setOriginalTitle(complete.original_name);
        try {
            MediaRating rating = new MediaRating("tmdb");
            rating.setRating(complete.vote_average);
            rating.setVotes(complete.vote_count);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.setReleaseDate(complete.first_air_date);
        md.setPlot(complete.overview);
        for (String string : ListUtils.nullSafe(complete.origin_country)) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), string));
                continue;
            }
            md.addCountry(string);
        }
        if (complete.episode_run_time != null && !complete.episode_run_time.isEmpty()) {
            md.setRuntime(complete.episode_run_time.get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)complete.poster_path)) {
            Iterator<BaseCompany> ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ((MediaArtwork)((Object)ma)).setPreviewUrl(this.artworkBaseUrl + "w342" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setDefaultUrl(this.artworkBaseUrl + "original" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setOriginalUrl(this.artworkBaseUrl + "original" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setLanguage(options.getLanguage().getLanguage());
            ((MediaArtwork)((Object)ma)).setTmdbId(complete.id);
            md.addMediaArt((MediaArtwork)((Object)ma));
        }
        for (Network network : ListUtils.nullSafe(complete.networks)) {
            md.addProductionCompany(network.name.trim());
        }
        for (BaseCompany baseCompany : ListUtils.nullSafe(complete.production_companies)) {
            md.addProductionCompany(baseCompany.name.trim());
        }
        md.setStatus(complete.status);
        if (complete.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complete.first_air_date);
            md.setYear(calendar.get(1));
        }
        if (complete.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(complete.credits.cast)) {
                Person cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
        }
        if (complete.external_ids != null) {
            if (complete.external_ids.tvdb_id != null && complete.external_ids.tvdb_id > 0) {
                md.setId("tvdb", complete.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)complete.external_ids.imdb_id)) {
                md.setId("imdb", complete.external_ids.imdb_id);
            }
            if (complete.external_ids.tvrage_id != null && complete.external_ids.tvrage_id > 0) {
                md.setId("tvrage", complete.external_ids.tvrage_id);
            }
        }
        if (complete.content_ratings != null) {
            CountryCode countryCode = options.getCertificationCountry();
            for (ContentRating country : ListUtils.nullSafe(complete.content_ratings.results)) {
                if (countryCode != null && countryCode.getAlpha2().compareToIgnoreCase(country.iso_3166_1) != 0 || StringUtils.isEmpty((CharSequence)country.rating)) continue;
                md.addCertification(MediaCertification.getCertification(country.iso_3166_1, country.rating));
            }
        }
        for (Genre genre : ListUtils.nullSafe(complete.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        for (TvSeason tvSeason : ListUtils.nullSafe(complete.seasons)) {
            if (tvSeason.season_number == null || !StringUtils.isNotBlank((CharSequence)tvSeason.name)) continue;
            md.addSeasonName(tvSeason.season_number, tvSeason.name);
        }
        if (complete.keywords != null) {
            for (BaseKeyword baseKeyword : ListUtils.nullSafe(complete.keywords.keywords)) {
                md.addTag(baseKeyword.name);
            }
        }
        if (md.getId("imdb") instanceof String && (imdbRating = RatingUtil.getImdbRating((String)md.getId("imdb"))) != null) {
            md.addRating(imdbRating);
        }
        return md;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        MediaRating imdbRating;
        Person cm;
        void var8_19;
        BaseTvEpisode baseTvEpisode;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        int tmdbId = 0;
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && MetadataUtil.isValidImdbId(options.getImdbId())) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByImdbId(options.getImdbId());
                if (baseTvEpisode != null) {
                    tmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by imdb id - {}", (Object)e.getMessage());
            }
        }
        if ((seasonNr == -1 || episodeNr == -1) && options.getIds().containsKey("tvdb")) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByTvdbId(options.getIdAsString("tvdb"));
                if (baseTvEpisode != null) {
                    tmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = options.createTvShowSearchAndScrapeOptions();
            tmdbId = tvShowSearchAndScrapeOptions.getTmdbId();
            if (tmdbId == 0 && MetadataUtil.isValidImdbId(tvShowSearchAndScrapeOptions.getImdbId())) {
                try {
                    tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, tvShowSearchAndScrapeOptions.getImdbId());
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
                }
            }
            if (tmdbId == 0 && tvShowSearchAndScrapeOptions.getIdAsIntOrDefault("tvdb", 0) > 0) {
                try {
                    tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, tvShowSearchAndScrapeOptions.getIdAsInteger("tvdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
                }
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        if ((seasonNr == -1 || episodeNr == -1) && options.getIds().containsKey("tmdb")) {
            List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
            for (MediaMetadata mediaMetadata : episodes) {
                if (((Integer)mediaMetadata.getId("tmdb")).intValue() != options.getIdAsInt("tmdb")) continue;
                seasonNr = mediaMetadata.getSeasonNumber();
                episodeNr = mediaMetadata.getEpisodeNumber();
                break;
            }
        }
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (seasonNr == -1 || episodeNr == -1) {
            LOGGER.warn("season number/episode number found");
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        Object var8_13 = null;
        TvSeason fullSeason = null;
        try {
            void var8_17;
            void var8_15;
            Response seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNr, language, new AppendToResponse(AppendToResponseItem.CREDITS)).execute();
            if (!seasonResponse.isSuccessful()) {
                throw new HttpException(seasonResponse.code(), seasonResponse.message());
            }
            fullSeason = (TvSeason)seasonResponse.body();
            for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                if (MetadataUtil.unboxInteger(ep.season_number, -1) != seasonNr || MetadataUtil.unboxInteger(ep.episode_number, -1) != episodeNr) continue;
                TvEpisode tvEpisode = ep;
                break;
            }
            if (var8_15 == null && !aired.isEmpty()) {
                for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                    SimpleDateFormat formatter;
                    String epAired;
                    if (ep.air_date == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)ep.air_date)).equals(aired)) continue;
                    TvEpisode tvEpisode = ep;
                    break;
                }
            }
            if (var8_17 != null) {
                Response episodeResponse = this.api.tvEpisodesService().episode(tmdbId, MetadataUtil.unboxInteger(var8_17.season_number, -1), MetadataUtil.unboxInteger(var8_17.episode_number, -1), language, new AppendToResponse(AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.IMAGES)).execute();
                if (!episodeResponse.isSuccessful()) {
                    throw new HttpException(seasonResponse.code(), seasonResponse.message());
                }
                TvEpisode tvEpisode = (TvEpisode)episodeResponse.body();
                this.injectTranslations(Locale.forLanguageTag(language), tvEpisode, tmdbId);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (var8_19 == null || fullSeason == null) {
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber(var8_19.episode_number));
        md.setSeasonNumber(TvUtils.getSeasonNumber(var8_19.season_number));
        md.setId(this.getId(), var8_19.id);
        if (var8_19.external_ids != null) {
            if (MetadataUtil.unboxInteger(var8_19.external_ids.tvdb_id) > 0) {
                md.setId("tvdb", var8_19.external_ids.tvdb_id);
            }
            if (MetadataUtil.isValidImdbId(var8_19.external_ids.imdb_id)) {
                md.setId("imdb", var8_19.external_ids.imdb_id);
            }
            if (MetadataUtil.unboxInteger(var8_19.external_ids.tvrage_id) > 0) {
                md.setId("tvrage", var8_19.external_ids.tvrage_id);
            }
        }
        md.setTitle(var8_19.name);
        md.setOriginalTitle(var8_19.originalName);
        md.setPlot(var8_19.overview);
        if (MetadataUtil.unboxInteger(var8_19.vote_count, 0) > 0) {
            try {
                MediaRating rating = new MediaRating("tmdb");
                rating.setRating(MetadataUtil.unboxDouble(var8_19.vote_average));
                rating.setVotes(MetadataUtil.unboxInteger(var8_19.vote_count));
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        md.setReleaseDate(var8_19.air_date);
        if (fullSeason.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(fullSeason.credits.cast)) {
                cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(fullSeason.credits.crew)) {
                cm = new Person();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(Person.Type.DIRECTOR);
                    cm.setRole(crewMember.department);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(Person.Type.WRITER);
                    cm.setRole(crewMember.department);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(Person.Type.PRODUCER);
                    cm.setRole(crewMember.job);
                }
                cm.setId(this.getProviderInfo().getId(), crewMember.id);
                cm.setName(crewMember.name);
                if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                md.addCastMember(cm);
            }
        }
        for (CastMember castMember : ListUtils.nullSafe(var8_19.guest_stars)) {
            cm = new Person(Person.Type.ACTOR);
            cm.setId(this.getProviderInfo().getId(), castMember.id);
            cm.setName(castMember.name);
            cm.setRole(castMember.character);
            if (castMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
            }
            if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
            }
            md.addCastMember(cm);
        }
        for (CrewMember crewMember : ListUtils.nullSafe(var8_19.crew)) {
            cm = new Person();
            if ("Director".equals(crewMember.job)) {
                cm.setType(Person.Type.DIRECTOR);
                cm.setRole(crewMember.department);
            } else if ("Writing".equals(crewMember.department)) {
                cm.setType(Person.Type.WRITER);
                cm.setRole(crewMember.department);
            } else {
                if (!"Production".equals(crewMember.department)) continue;
                cm.setType(Person.Type.PRODUCER);
                cm.setRole(crewMember.job);
            }
            cm.setId(this.getProviderInfo().getId(), crewMember.id);
            cm.setName(crewMember.name);
            if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
            }
            if (crewMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
            }
            md.addCastMember(cm);
        }
        if (var8_19.images != null && ListUtils.isNotEmpty(var8_19.images.stills)) {
            for (Image image : var8_19.images.stills) {
                MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl(this.artworkBaseUrl + "w300" + image.file_path);
                ma.setDefaultUrl(this.artworkBaseUrl + "original" + image.file_path);
                ma.setOriginalUrl(this.artworkBaseUrl + "original" + image.file_path);
                ma.addImageSize(image.width, image.height, this.artworkBaseUrl + "original" + image.file_path);
                if (1280 < image.width) {
                    ma.addImageSize(1280, image.height * 1280 / image.width, this.artworkBaseUrl + "w1280" + image.file_path);
                }
                if (300 < image.width) {
                    ma.addImageSize(300, image.height * 300 / image.width, this.artworkBaseUrl + "w300" + image.file_path);
                }
                md.addMediaArt(ma);
            }
        } else if (StringUtils.isNotBlank((CharSequence)var8_19.still_path)) {
            MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(this.artworkBaseUrl + "w300" + var8_19.still_path);
            ma.setDefaultUrl(this.artworkBaseUrl + "original" + var8_19.still_path);
            ma.setOriginalUrl(this.artworkBaseUrl + "original" + var8_19.still_path);
            ma.addImageSize(1920, 1080, this.artworkBaseUrl + "original" + var8_19.still_path);
            md.addMediaArt(ma);
        }
        if (md.getId("imdb") instanceof String && (imdbRating = RatingUtil.getImdbRating((String)md.getId("imdb"))) != null) {
            md.addRating(imdbRating);
        }
        return md;
    }

    private BaseTvEpisode getBaseTvEpisodeByImdbId(String imdbId) throws IOException {
        FindResults findResults = (FindResults)this.api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
        if (findResults != null && ListUtils.isNotEmpty(findResults.tv_episode_results)) {
            return findResults.tv_episode_results.get(0);
        }
        return null;
    }

    private BaseTvEpisode getBaseTvEpisodeByTvdbId(String tvdbId) throws IOException {
        FindResults findResults = (FindResults)this.api.findService().find(tvdbId, ExternalSource.TVDB_ID, null).execute().body();
        if (findResults != null && ListUtils.isNotEmpty(findResults.tv_episode_results)) {
            return findResults.tv_episode_results.get(0);
        }
        return null;
    }

    private void injectTranslations(Locale language, TvShow show) {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            String[] val = this.getValuesFromTranslation(show.translations, language);
            if (StringUtils.isBlank((CharSequence)val[0]) && language.getLanguage().equals(show.original_language)) {
                val[0] = show.original_name;
            }
            String[] temp = this.getValuesFromTranslation(show.translations, fallbackLanguage);
            if (StringUtils.isBlank((CharSequence)val[0])) {
                val[0] = temp[0];
            }
            if (StringUtils.isBlank((CharSequence)val[1])) {
                val[1] = temp[1];
            }
            if (StringUtils.isNotBlank((CharSequence)val[0])) {
                show.name = val[0];
            }
            if (StringUtils.isNotBlank((CharSequence)val[1])) {
                show.overview = val[1];
            }
        }
    }

    private void injectTranslations(Locale language, BaseTvShow show) throws IOException {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String lang = this.getProviderInfo().getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.tvService().tv(show.id, lang, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                TvShow s = (TvShow)httpResponse.body();
                String[] val = this.getValuesFromTranslation(s.translations, language);
                String[] temp = this.getValuesFromTranslation(s.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                if (StringUtils.isNotBlank((CharSequence)val[0])) {
                    show.name = val[0];
                }
                if (StringUtils.isNotBlank((CharSequence)val[1])) {
                    show.overview = val[1];
                }
            }
        }
    }

    private void injectTranslations(Locale language, TvEpisode episode, int showId) {
        String originalLanguage;
        String[] val;
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            val = this.getValuesFromTranslation(episode.translations, language);
            String[] temp = this.getValuesFromTranslation(episode.translations, fallbackLanguage);
            if (StringUtils.isBlank((CharSequence)val[0])) {
                val[0] = temp[0];
            }
            if (StringUtils.isBlank((CharSequence)val[1])) {
                val[1] = temp[1];
            }
            if ((StringUtils.isBlank((CharSequence)episode.name) || this.isEpisodesNameDefault(episode, episode.episode_number).booleanValue()) && StringUtils.isNotBlank((CharSequence)val[0])) {
                episode.name = val[0];
            }
            if (StringUtils.isNotBlank((CharSequence)val[1])) {
                episode.overview = val[1];
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(originalLanguage = this.getOriginalLanguage(showId))) && StringUtils.isNotBlank((CharSequence)(val = this.getValuesFromTranslation(episode.translations, Locale.forLanguageTag(originalLanguage)))[0])) {
            episode.originalName = val[0];
        }
    }

    private Integer toInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private Boolean isEpisodesNameDefault(BaseTvEpisode episode, Integer episodeNr) {
        Integer potentialEpisodeNumber;
        String[] originalEpisodeName = episode.name.split(" ");
        return originalEpisodeName.length == 2 && (potentialEpisodeNumber = this.toInteger(originalEpisodeName[1])) != null && (potentialEpisodeNumber.equals(episode.episode_number) || potentialEpisodeNumber.equals(episodeNr));
    }

    private MediaMetadata morphTvEpisodeToMediaMetadata(BaseTvEpisode episode) {
        MediaMetadata ep = new MediaMetadata(this.getId());
        ep.setId(this.getProviderInfo().getId(), episode.id);
        ep.setEpisodeNumber(episode.episode_number);
        ep.setSeasonNumber(episode.season_number);
        ep.setTitle(episode.name);
        ep.setPlot(episode.overview);
        if (episode.vote_average != null && MetadataUtil.unboxInteger(episode.vote_count, 0) > 0) {
            MediaRating rating = new MediaRating(this.getProviderInfo().getId());
            rating.setRating(episode.vote_average);
            rating.setVotes(episode.vote_count);
            rating.setMaxValue(10);
            ep.addRating(rating);
        }
        if (episode.air_date != null) {
            ep.setReleaseDate(episode.air_date);
        }
        return ep;
    }

    private MediaSearchResult morphTvShowToSearchResult(BaseTvShow tvShow, TvShowSearchAndScrapeOptions query) {
        MediaSearchResult result = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
        result.setId(Integer.toString(tvShow.id));
        result.setTitle(tvShow.name);
        result.setOriginalTitle(tvShow.original_name);
        result.setOverview(tvShow.overview);
        if (tvShow.poster_path != null && !tvShow.poster_path.isEmpty()) {
            result.setPosterUrl(this.artworkBaseUrl + "w342" + tvShow.poster_path);
        }
        if (tvShow.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tvShow.first_air_date);
            result.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(result.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(result.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            result.setScore(1.0f);
        } else {
            result.calculateScore(query);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOriginalLanguage(int tmdbId) {
        String cache = ORIGINAL_LANGUAGE_CACHE_MAP.get(tmdbId);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            return cache;
        }
        String originalLanguage = "";
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, null).execute();
            if (!httpResponse.isSuccessful()) {
                String string = "";
                return string;
            }
            TvShow complete = (TvShow)httpResponse.body();
            if (StringUtils.isNotBlank((CharSequence)complete.original_language)) {
                originalLanguage = complete.original_language;
            }
        }
        catch (Exception e) {
            originalLanguage = "";
        }
        finally {
            ORIGINAL_LANGUAGE_CACHE_MAP.put(tmdbId, originalLanguage);
        }
        return originalLanguage;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }
}

