/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieTranslation;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieArtworkProvider;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.RatingUtil;
import retrofit2.Response;

public class TraktMovieMetadataProvider
extends TraktMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktMovieMetadataProvider.class);

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search() - {}", (Object)options);
        this.initAPI();
        TmdbMovieArtworkProvider tmdb = new TmdbMovieArtworkProvider();
        String searchString = "";
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        List searchResults = null;
        try {
            Response response = this.api.search().textQueryMovie(searchString, null, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
            if (!response.isSuccessful()) {
                LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                throw new HttpException(response.code(), response.message());
            }
            searchResults = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("Problem scraping for {} - {}", (Object)searchString, (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            if (tmdb.isActive() && MetadataUtil.isValidImdbId(m.getIMDBId()) || m.getIdAsInt("tmdb") > 0) {
                try {
                    ArtworkSearchAndScrapeOptions tmdbOptions = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE);
                    tmdbOptions.setIds(m.getIds());
                    tmdbOptions.setLanguage(options.getLanguage());
                    tmdbOptions.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                    List<MediaArtwork> artworks = tmdb.getArtwork(tmdbOptions);
                    if (ListUtils.isNotEmpty(artworks)) {
                        m.setPosterUrl(artworks.get(0).getPreviewUrl());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not get artwork from tmdb - {}", (Object)e.getMessage());
                }
            }
            results.add(m);
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        MediaRating imdbRating;
        MovieTranslation trans;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        String id = options.getIdAsString(this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        LOGGER.debug("Trakt.tv: getMetadata: id = {}", (Object)id);
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Movie movie = null;
        Credits credits = null;
        try {
            Response response = this.api.movies().summary(id, Extended.FULL).execute();
            if (!response.isSuccessful()) {
                LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                throw new HttpException(response.code(), response.message());
            }
            movie = (Movie)response.body();
            if (!"en".equals(lang)) {
                translations = (List)this.api.movies().translation(id, lang).execute().body();
            }
            credits = (Credits)this.api.movies().people(id).execute().body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        MovieTranslation movieTranslation = trans = translations == null || translations.isEmpty() ? null : (MovieTranslation)translations.get(0);
        if (trans != null) {
            md.setTitle(StringUtils.isBlank((CharSequence)trans.title) ? movie.title : trans.title);
            md.setTagline(StringUtils.isBlank((CharSequence)trans.tagline) ? movie.tagline : trans.tagline);
            md.setPlot(StringUtils.isBlank((CharSequence)trans.overview) ? movie.overview : trans.overview);
        } else {
            md.setTitle(movie.title);
            md.setTagline(movie.tagline);
            md.setPlot(movie.overview);
        }
        md.setYear(movie.year);
        md.setRuntime(movie.runtime);
        md.addCertification(MediaCertification.findCertification(movie.certification));
        md.setReleaseDate(TraktUtils.toDate(movie.released));
        try {
            MediaRating rating = new MediaRating("trakt");
            rating.setRating((double)Math.round(movie.rating * 10.0) / 10.0);
            rating.setVotes(movie.votes);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        if (movie.ids != null) {
            md.setId(this.getId(), movie.ids.trakt);
            if (movie.ids.tmdb != null && movie.ids.tmdb > 0) {
                md.setId("tmdb", movie.ids.tmdb);
            }
            if (MetadataUtil.isValidImdbId(movie.ids.imdb)) {
                md.setId("imdb", movie.ids.imdb);
            }
        }
        for (String genreAsString : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe(credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, Person.Type.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.WRITER));
                }
            }
        }
        if (md.getId("imdb") instanceof String && (imdbRating = RatingUtil.getImdbRating((String)md.getId("imdb"))) != null) {
            md.addRating(imdbRating);
        }
        return md;
    }
}

