/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvdbv3;

import com.uwetrottmann.thetvdb.TheTvdb;
import com.uwetrottmann.thetvdb.entities.Episode;
import com.uwetrottmann.thetvdb.entities.EpisodeResponse;
import com.uwetrottmann.thetvdb.entities.Language;
import com.uwetrottmann.thetvdb.entities.LanguagesResponse;
import com.uwetrottmann.thetvdb.entities.Series;
import com.uwetrottmann.thetvdb.entities.SeriesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import retrofit2.Response;

abstract class TvdbV3MetadataProvider
implements IMediaProvider {
    private static final String ID = "tvdbv3";
    protected static final String ARTWORK_URL = "https://artworks.thetvdb.com/banners/";
    protected static final String FALLBACK_LANGUAGE = "fallbackLanguage";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected final List<Language> tvdbLanguages = new ArrayList<Language>();
    protected TheTvdb tvdb;

    TvdbV3MetadataProvider() {
    }

    protected abstract Logger getLogger();

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), "thetvdb.com - legacy API v3", "<html><h3>The TVDB</h3><br />An open database for television fans. This scraper is able to scrape TV series metadata and artwork.<br /><b>Legacy API v3.</b> This API will be turned off in the first half of 2022.</html>", TvdbV3MetadataProvider.class.getResource("/org/tinymediamanager/scraper/thetvdbv3_com.svg"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getConfig().getValue("apiKey"));
    }

    protected synchronized void initAPI() throws ScrapeException {
        String userApiKey;
        if (this.tvdb == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                this.tvdb = new TheTvdb(this.getApiKey()){
                    private OkHttpClient okHttpClient;

                    protected synchronized OkHttpClient okHttpClient() {
                        if (this.okHttpClient == null) {
                            OkHttpClient.Builder builder = TmmHttpClient.newBuilder(true);
                            this.setOkHttpClientDefaults(builder);
                            this.okHttpClient = builder.build();
                        }
                        return this.okHttpClient;
                    }
                };
                Response httpResponse = this.tvdb.languages().allAvailable().execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                LanguagesResponse response = (LanguagesResponse)httpResponse.body();
                if (response == null) {
                    throw new Exception("Could not connect to TVDB");
                }
                this.tvdbLanguages.clear();
                this.tvdbLanguages.addAll(response.data);
            }
            catch (Exception e) {
                this.getLogger().warn("could not initialize API: {}", (Object)e.getMessage());
                this.tvdb = null;
                throw new ScrapeException(e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(userApiKey = this.providerInfo.getConfig().getValue("apiKey")))) {
            this.tvdb.apiKey(userApiKey);
        }
        if (StringUtils.isBlank((CharSequence)userApiKey)) {
            this.tvdb.apiKey(this.getApiKey());
        }
    }

    protected void fillFallbackLanguages(String language, String fallbackLanguage, Series serie) throws IOException {
        Response httpResponse;
        if ((StringUtils.isEmpty((CharSequence)serie.seriesName) || StringUtils.isEmpty((CharSequence)serie.overview)) && !fallbackLanguage.equals(language)) {
            this.getLogger().trace("Getting show in fallback language {}", (Object)fallbackLanguage);
            httpResponse = this.tvdb.series().series(serie.id.intValue(), fallbackLanguage).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            serie.seriesName = StringUtils.isEmpty((CharSequence)serie.seriesName) ? ((SeriesResponse)httpResponse.body()).data.seriesName : serie.seriesName;
            String string = serie.overview = StringUtils.isEmpty((CharSequence)serie.overview) ? ((SeriesResponse)httpResponse.body()).data.overview : serie.overview;
        }
        if ((StringUtils.isEmpty((CharSequence)serie.seriesName) || StringUtils.isEmpty((CharSequence)serie.overview)) && !fallbackLanguage.equals("en") && !language.equals("en")) {
            this.getLogger().trace("Getting show in fallback language {}", (Object)"en");
            httpResponse = this.tvdb.series().series(serie.id.intValue(), "en").execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            serie.seriesName = StringUtils.isEmpty((CharSequence)serie.seriesName) ? ((SeriesResponse)httpResponse.body()).data.seriesName : serie.seriesName;
            serie.overview = StringUtils.isEmpty((CharSequence)serie.overview) ? ((SeriesResponse)httpResponse.body()).data.overview : serie.overview;
        }
    }

    protected void fillFallbackLanguages(String language, String fallbackLanguage, Episode episode) throws IOException {
        if ((StringUtils.isEmpty((CharSequence)episode.episodeName) || StringUtils.isEmpty((CharSequence)episode.overview)) && !fallbackLanguage.equals(language)) {
            this.getLogger().trace("Getting episode S{}E{} in fallback language {}", new Object[]{episode.airedSeason, episode.airedEpisodeNumber, fallbackLanguage});
            Response httpResponse = this.tvdb.episodes().get(episode.id.intValue(), fallbackLanguage).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode.episodeName = StringUtils.isEmpty((CharSequence)episode.episodeName) ? ((EpisodeResponse)httpResponse.body()).data.episodeName : episode.episodeName;
            episode.overview = StringUtils.isEmpty((CharSequence)episode.overview) ? ((EpisodeResponse)httpResponse.body()).data.overview : episode.overview;
        }
    }

    protected String clearYearFromTitle(String title, int year) {
        return title.replaceAll("\\(" + year + "\\)$", "").trim();
    }
}

