/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvdbv3;

import com.uwetrottmann.thetvdb.entities.Actor;
import com.uwetrottmann.thetvdb.entities.ActorsResponse;
import com.uwetrottmann.thetvdb.entities.Episode;
import com.uwetrottmann.thetvdb.entities.EpisodesResponse;
import com.uwetrottmann.thetvdb.entities.Series;
import com.uwetrottmann.thetvdb.entities.SeriesResponse;
import com.uwetrottmann.thetvdb.entities.SeriesResultsResponse;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.tvdbv3.TvdbV3MetadataProvider;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.RatingUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

public class TvdbV3TvShowMetadataProvider
extends TvdbV3MetadataProvider
implements ITvShowMetadataProvider,
ITvShowTvdbMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvdbV3TvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(600L, 5L);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.values()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        info.getConfig().addSelect("fallbackLanguage", fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        MediaRating imdbRating;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        Integer id = options.getIdAsInteger("tvdb");
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvdb"});
        }
        String language = options.getLanguage().getLanguage();
        String fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).getLanguage();
        Series show = null;
        try {
            Response httpResponse = this.tvdb.series().series(id.intValue(), options.getLanguage().getLanguage()).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesResponse)httpResponse.body()).data;
            this.fillFallbackLanguages(language, fallbackLanguage, show);
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        md.setId("tvdb", show.id);
        md.setTitle(show.seriesName);
        if (MetadataUtil.isValidImdbId(show.imdbId)) {
            md.setId("imdb", show.imdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)show.zap2itId)) {
            md.setId("zap2it", show.zap2itId);
        }
        md.setPlot(show.overview);
        try {
            md.setRuntime(Integer.parseInt(show.runtime));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse runtime: {}", (Object)e.getMessage());
            md.setRuntime(0);
        }
        try {
            MediaRating rating = new MediaRating("tvdb");
            rating.setRating(show.siteRating.floatValue());
            rating.setVotes(TvUtils.parseInt(show.siteRatingCount));
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            md.setReleaseDate(StrgUtils.parseDate(show.firstAired));
        }
        catch (ParseException e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        try {
            Date date = StrgUtils.parseDate(show.firstAired);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int y = calendar.get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                md.setTitle(this.clearYearFromTitle(md.getTitle(), y));
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        md.setStatus(show.status);
        md.addProductionCompany(show.network);
        ArrayList actors = new ArrayList();
        try {
            Response httpResponse = this.tvdb.series().actors(id.intValue()).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            actors.addAll(((ActorsResponse)httpResponse.body()).data);
        }
        catch (Exception e) {
            LOGGER.error("failed to get actors: {}", (Object)e.getMessage());
        }
        for (Actor actor : actors) {
            Person member = new Person(Person.Type.ACTOR);
            member.setId("tvdb", actor.id);
            member.setName(actor.name);
            member.setRole(actor.role);
            if (StringUtils.isNotBlank((CharSequence)actor.image)) {
                member.setThumbUrl("https://artworks.thetvdb.com/banners/" + actor.image);
            }
            md.addCastMember(member);
        }
        md.addCertification(MediaCertification.findCertification(show.rating));
        for (String genreAsString : ListUtils.nullSafe(show.genre)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        if (md.getId("imdb") instanceof String && (imdbRating = RatingUtil.getImdbRating((String)md.getId("imdb"))) != null) {
            md.addRating(imdbRating);
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        boolean useDvdOrder = false;
        int showId = options.createTvShowSearchAndScrapeOptions().getIdAsIntOrDefault("tvdb", 0);
        if (showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvdb"});
        }
        int episodeTvdbId = options.getIdAsIntOrDefault("tvdb", 0);
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("dvdSeasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("dvdEpisodeNr", -1);
            if (seasonNr != -1 && episodeNr != -1) {
                useDvdOrder = true;
            }
        }
        Date releaseDate = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            releaseDate = options.getMetadata().getReleaseDate();
        }
        if (releaseDate == null && (seasonNr == -1 || episodeNr == -1) && episodeTvdbId == 0) {
            LOGGER.warn("no aired date/season number/episode number found");
            throw new MissingIdException("episodeNr", "seasonNr");
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        MediaMetadata foundEpisode = null;
        for (MediaMetadata episode : episodes) {
            if (episodeTvdbId == (Integer)episode.getId("tvdb")) {
                foundEpisode = episode;
                break;
            }
            if (useDvdOrder && episode.getDvdSeasonNumber() == seasonNr && episode.getDvdEpisodeNumber() == episodeNr) {
                foundEpisode = episode;
                break;
            }
            if (useDvdOrder || episode.getSeasonNumber() != seasonNr || episode.getEpisodeNumber() != episodeNr) continue;
            foundEpisode = episode;
            break;
        }
        if (foundEpisode == null && releaseDate != null) {
            for (MediaMetadata episode : episodes) {
                if (episode.getReleaseDate() != releaseDate) continue;
                foundEpisode = episode;
                break;
            }
        }
        if (foundEpisode == null) {
            throw new NothingFoundException();
        }
        return foundEpisode;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Object res;
        Response httpResponse;
        String imdbId;
        this.initAPI();
        LOGGER.debug("search() {}", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        String string = imdbId = options.getImdbId().isEmpty() ? null : options.getImdbId();
        if (MetadataUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
            searchString = null;
        }
        if (MetadataUtil.isValidImdbId(imdbId)) {
            searchString = null;
        }
        int tvdbId = options.getIdAsInt("tvdb");
        String language = options.getLanguage().getLanguage();
        String fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).getLanguage();
        ArrayList<Object> series = new ArrayList<Object>();
        if (tvdbId != 0) {
            LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
            try {
                httpResponse = this.tvdb.series().series(tvdbId, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                res = ((SeriesResponse)httpResponse.body()).data;
                this.fillFallbackLanguages(language, fallbackLanguage, (Series)res);
                series.add(res);
            }
            catch (Exception e) {
                LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (!(!series.isEmpty() || StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isEmpty((CharSequence)imdbId))) {
            try {
                httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, language).execute();
                if (!httpResponse.isSuccessful()) {
                    if (!fallbackLanguage.equals(language)) {
                        LOGGER.debug("not found - trying with fallback language {}", (Object)fallbackLanguage);
                        httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, fallbackLanguage).execute();
                    }
                    if (!httpResponse.isSuccessful()) {
                        if (!fallbackLanguage.equals("en") && !language.equals("en")) {
                            LOGGER.debug("not found - trying with EN language");
                            httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, "en").execute();
                        }
                        if (!httpResponse.isSuccessful()) {
                            throw new HttpException(httpResponse.code(), httpResponse.message());
                        }
                    }
                }
                res = ((SeriesResultsResponse)httpResponse.body()).data;
                Iterator iterator = res.iterator();
                while (iterator.hasNext()) {
                    Series s = (Series)iterator.next();
                    this.fillFallbackLanguages(language, fallbackLanguage, s);
                }
                series.addAll((Collection<Object>)res);
            }
            catch (Exception e) {
                LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (series.isEmpty()) {
            return results;
        }
        HashMap<Integer, MediaSearchResult> resultMap = new HashMap<Integer, MediaSearchResult>();
        for (Series series2 : series) {
            if (resultMap.containsKey(series2.id)) continue;
            MediaSearchResult result = new MediaSearchResult("tvdb", options.getMediaType());
            result.setId(series2.id.toString());
            result.setTitle(series2.seriesName);
            result.setOverview(series2.overview);
            try {
                int year = Integer.parseInt(series2.firstAired.substring(0, 4));
                result.setYear(year);
                if (year != 0 && result.getTitle().contains(String.valueOf(year))) {
                    LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)year);
                    result.setTitle(this.clearYearFromTitle(result.getTitle(), year));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isNotBlank((CharSequence)series2.poster)) {
                result.setPosterUrl("https://artworks.thetvdb.com/banners/" + series2.poster.replace("/banners/", ""));
            }
            result.calculateScore(options);
            resultMap.put(series2.id, result);
        }
        results.addAll(resultMap.values());
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        this.initAPI();
        Integer showId = options.getIdAsInteger("tvdb");
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvdb"});
        }
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(showId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        episodes = new ArrayList<MediaMetadata>();
        ArrayList eps = new ArrayList();
        try {
            String language = options.getLanguage().getLanguage();
            String fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).getLanguage();
            int counter = 1;
            while (true) {
                Response httpResponse;
                if (!(httpResponse = this.tvdb.series().episodes(showId.intValue(), Integer.valueOf(counter), language).execute()).isSuccessful() && counter == 1) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                if (httpResponse.isSuccessful() || counter <= 1) {
                    EpisodesResponse response = (EpisodesResponse)httpResponse.body();
                    for (Episode ep : response.data) {
                        this.fillFallbackLanguages(language, fallbackLanguage, ep);
                    }
                    eps.addAll(response.data);
                    if (response.data.size() >= 100) {
                        ++counter;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (Episode ep : eps) {
            MediaRating imdbRating;
            Person cm;
            String[] multiple;
            MediaMetadata episode = new MediaMetadata("tvdb");
            episode.setId("tvdb", ep.id);
            if (MetadataUtil.isValidImdbId(ep.imdbId)) {
                episode.setId("imdb", ep.imdbId);
            }
            episode.setSeasonNumber(TvUtils.getSeasonNumber(ep.airedSeason));
            episode.setEpisodeNumber(TvUtils.getEpisodeNumber(ep.airedEpisodeNumber));
            episode.setDvdSeasonNumber(TvUtils.getSeasonNumber(ep.dvdSeason));
            episode.setDvdEpisodeNumber(TvUtils.getEpisodeNumber(ep.dvdEpisodeNumber));
            if (MetadataUtil.unboxInteger(ep.airsBeforeSeason, -1) > -1) {
                episode.setDisplaySeasonNumber(MetadataUtil.unboxInteger(ep.airsBeforeSeason));
            }
            if (MetadataUtil.unboxInteger(ep.airsBeforeEpisode, -1) > -1) {
                episode.setDisplayEpisodeNumber(MetadataUtil.unboxInteger(ep.airsBeforeEpisode));
            }
            if (MetadataUtil.unboxInteger(ep.airsAfterSeason, -1) > -1) {
                episode.setDisplaySeasonNumber(MetadataUtil.unboxInteger(ep.airsAfterSeason));
                episode.setDisplayEpisodeNumber(4096);
            }
            episode.setTitle(ep.episodeName);
            episode.setPlot(ep.overview);
            try {
                episode.setReleaseDate(StrgUtils.parseDate(ep.firstAired));
            }
            catch (Exception ignored) {
                LOGGER.trace("Could not parse date: {}", (Object)ep.firstAired);
            }
            try {
                MediaRating rating = new MediaRating("tvdb");
                rating.setRating(ep.siteRating.floatValue());
                rating.setVotes(TvUtils.parseInt(ep.siteRatingCount));
                rating.setMaxValue(10);
                episode.addRating(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
            if (ep.directors != null && !ep.directors.isEmpty()) {
                for (String director : ep.directors) {
                    for (String g2 : multiple = director.split(",")) {
                        cm = new Person(Person.Type.DIRECTOR);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (ep.writers != null && !ep.writers.isEmpty()) {
                for (String writer : ep.writers) {
                    for (String g2 : multiple = writer.split(",")) {
                        cm = new Person(Person.Type.WRITER);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (ep.guestStars != null && !ep.guestStars.isEmpty()) {
                for (String guest : ep.guestStars) {
                    for (String g2 : multiple = guest.split(",")) {
                        cm = new Person(Person.Type.ACTOR);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)ep.filename)) {
                MediaArtwork ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl("https://artworks.thetvdb.com/banners/" + ep.filename);
                ma.setDefaultUrl("https://artworks.thetvdb.com/banners/" + ep.filename);
                ma.setOriginalUrl("https://artworks.thetvdb.com/banners/" + ep.filename);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ep.thumbWidth, ep.thumbHeight})) {
                    try {
                        ma.addImageSize(Integer.parseInt(ep.thumbWidth), Integer.parseInt(ep.thumbHeight), "https://artworks.thetvdb.com/banners/" + ep.filename);
                    }
                    catch (Exception e) {
                        ma.addImageSize(0, 0, "https://artworks.thetvdb.com/banners/" + ep.filename);
                    }
                }
                episode.addMediaArt(ma);
            }
            if (episode.getId("imdb") instanceof String && (imdbRating = RatingUtil.getImdbRating((String)episode.getId("imdb"))) != null) {
                episode.addRating(imdbRating);
            }
            episodes.add(episode);
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(showId + "_" + options.getLanguage().getLanguage(), episodes);
        }
        return episodes;
    }
}

