/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvmaze;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.tvmaze.service.Controller;

abstract class TvMazeMetadataProvider
implements IMediaProvider {
    public static final String ID = "tvmaze";
    protected final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected Controller controller;

    TvMazeMetadataProvider() {
    }

    protected abstract String getSubId();

    protected abstract Logger getLogger();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), "tvmaze.com", "TVmaze is a community of TV lovers and dedicated contributors that discuss and help maintain tv information on the web.", TvMazeMetadataProvider.class.getResource("/org/tinymediamanager/scraper/tvmaze.png"));
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    protected synchronized void initAPI() throws ScrapeException {
        if (this.controller == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                this.controller = new Controller(this.getApiKey(), false);
            }
            catch (Exception e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.controller = null;
                throw new ScrapeException(e);
            }
        }
    }

    int parseYear(String date) throws ParseException {
        Date year = new SimpleDateFormat("yyyy-MM-dd").parse(date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(year);
        return cal.get(1);
    }
}

