/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvmaze.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.tvmaze.entities.Cast;
import org.tinymediamanager.scraper.tvmaze.entities.Episode;
import org.tinymediamanager.scraper.tvmaze.entities.Image;
import org.tinymediamanager.scraper.tvmaze.entities.Season;
import org.tinymediamanager.scraper.tvmaze.entities.Show;
import org.tinymediamanager.scraper.tvmaze.entities.Shows;
import org.tinymediamanager.scraper.tvmaze.service.TvMazeService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    Retrofit retrofit;
    private String apiKey;

    public Controller(String apiKey, boolean debug) {
        this.apiKey = apiKey;
        OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
        if (debug) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
        this.retrofit = this.buildRetrofitInstance(builder.build());
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    private Retrofit buildRetrofitInstance(OkHttpClient client) {
        return new Retrofit.Builder().client(client).baseUrl(this.apiKey).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).build();
    }

    private TvMazeService getService() {
        return (TvMazeService)this.retrofit.create(TvMazeService.class);
    }

    public List<Shows> getTvShowSearchResults(String query) throws IOException {
        return (List)this.getService().showSearch(query).execute().body();
    }

    public Show getMainInformation(int id) throws IOException {
        return (Show)this.getService().show_main_information(id).execute().body();
    }

    public List<Season> getSeasons(int id) throws IOException {
        return (List)this.getService().seasonList(id).execute().body();
    }

    public List<Episode> getEpisodes(int id) throws IOException {
        return (List)this.getService().episodeList(id).execute().body();
    }

    public Episode getEpisode(int showId, int seasonNr, int episodeNr) throws Exception {
        return (Episode)this.getService().episode(showId, seasonNr, episodeNr).execute().body();
    }

    public List<Image> getImages(int id) throws IOException {
        return (List)this.getService().imagesList(id).execute().body();
    }

    public List<Cast> getCast(int id) throws IOException {
        return (List)this.getService().castList(id).execute().body();
    }
}

