/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class RatingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingUtil.class);
    private static final String IMDB_DB = "imdb_ratings.db";
    private static MVStore mvStore;
    private static MVMap<String, String> ratingMap;

    private RatingUtil() {
        throw new IllegalAccessError();
    }

    public static synchronized MediaRating getImdbRating(String imdbId) {
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            return null;
        }
        if (mvStore == null) {
            RatingUtil.initImdbRatings();
        }
        if (ratingMap == null) {
            return null;
        }
        try {
            String[] cols;
            String line = (String)ratingMap.get((Object)imdbId);
            if (StringUtils.isNotBlank((CharSequence)line) && (cols = line.split("\t")).length > 2 && MetadataUtil.isValidImdbId(cols[0])) {
                try {
                    return new MediaRating("imdb", Float.parseFloat(cols[1]), Integer.parseInt(cols[2]));
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("could not read the MVstore - '{}'", (Object)e.getMessage());
            Utils.deleteFileSafely(Paths.get(Globals.CACHE_FOLDER, IMDB_DB));
            RatingUtil.shutdown();
        }
        return null;
    }

    private static void initImdbRatings() {
        block17: {
            Path databaseFile = Paths.get(Globals.CACHE_FOLDER, IMDB_DB);
            try {
                mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitDisabled().open();
                ratingMap = mvStore.openMap("ratings");
                OnDiskCachedUrl cachedUrl = new OnDiskCachedUrl("https://datasets.imdbws.com/title.ratings.tsv.gz", 1, TimeUnit.DAYS);
                try (InputStream httpInputStream = cachedUrl.getInputStream();){
                    if (String.valueOf(cachedUrl.getContentLength()).equals(ratingMap.get((Object)"length"))) break block17;
                    try (GzipCompressorInputStream in = new GzipCompressorInputStream(httpInputStream);){
                        String[] lines;
                        ratingMap.clear();
                        String content = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                        for (String line : lines = content.split("\n")) {
                            try {
                                String[] cols = line.split("\t");
                                if (cols.length <= 2 || !MetadataUtil.isValidImdbId(cols[0])) continue;
                                ratingMap.put((Object)cols[0], (Object)line);
                            }
                            catch (Exception e) {
                                LOGGER.debug("could not store rating - {}", (Object)e.getMessage());
                            }
                        }
                    }
                    ratingMap.put((Object)"length", (Object)String.valueOf(cachedUrl.getContentLength()));
                    mvStore.commit();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("could not create IMDB ratings database - '{}'", (Object)e.getMessage());
                Utils.deleteFileSafely(Paths.get(Globals.CACHE_FOLDER, IMDB_DB));
                RatingUtil.shutdown();
            }
        }
    }

    public static synchronized void shutdown() {
        try {
            if (mvStore != null && !mvStore.isClosed()) {
                mvStore.compactMoveChunks();
                mvStore.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("could not close MVstore - deleting the cache");
            Utils.deleteFileSafely(Paths.get(Globals.CACHE_FOLDER, IMDB_DB));
        }
        finally {
            mvStore = null;
            ratingMap = null;
        }
    }
}

