/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.call.Application;
import org.tinymediamanager.jsonrpc.api.call.AudioLibrary;
import org.tinymediamanager.jsonrpc.api.call.Files;
import org.tinymediamanager.jsonrpc.api.call.System;
import org.tinymediamanager.jsonrpc.api.call.VideoLibrary;
import org.tinymediamanager.jsonrpc.api.model.ApplicationModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiCallback;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.ConnectionListener;
import org.tinymediamanager.jsonrpc.io.JavaConnectionManager;
import org.tinymediamanager.jsonrpc.io.JsonApiRequest;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.SplitUri;

public class KodiRPC {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiRPC.class);
    private static KodiRPC instance;
    private final JavaConnectionManager connectionManager = new JavaConnectionManager();
    private final List<SplitUri> videodatasources = new ArrayList<SplitUri>();
    private final List<String> videodatasourcesAsString = new ArrayList<String>();
    private final List<SplitUri> audiodatasources = new ArrayList<SplitUri>();
    private final Map<UUID, Integer> moviemappings = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> tvshowmappings = new HashMap<UUID, Integer>();
    private String kodiVersion = "";

    private KodiRPC() {
        this.connectionManager.registerConnectionListener(new ConnectionListener(){

            public void notificationReceived(AbstractEvent event) {
                LOGGER.info("Event received: {}", (Object)event);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.INFO, event, "Event received"));
            }

            public void disconnected() {
                LOGGER.info("Event: Disconnected");
                MessageManager.instance.pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi disconnected"));
            }

            public void connected() {
                LOGGER.info("Event: Connected to {}", (Object)KodiRPC.this.connectionManager.getHostConfig().getAddress());
                MessageManager.instance.pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi connected"));
            }
        });
    }

    public static synchronized KodiRPC getInstance() {
        if (instance == null) {
            instance = new KodiRPC();
        }
        return instance;
    }

    public boolean isConnected() {
        return this.connectionManager.isConnected();
    }

    public String getVersion() {
        return "Kodi " + this.kodiVersion;
    }

    public void cleanVideoLibrary() {
        VideoLibrary.Clean call = new VideoLibrary.Clean(Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanVideoLibrary() {
        VideoLibrary.Scan call = new VideoLibrary.Scan(null, Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanVideoLibrary(String dir) {
        VideoLibrary.Scan call = new VideoLibrary.Scan(dir, Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public List<SplitUri> getVideoDataSources() {
        return this.videodatasources;
    }

    public List<String> getVideoDataSourcesAsString() {
        return this.videodatasourcesAsString;
    }

    private void getAndSetVideoDataSources() {
        Files.GetSources call = new Files.GetSources("video");
        this.videodatasources.clear();
        this.videodatasourcesAsString.clear();
        this.send((AbstractCall<?>)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            try {
                for (ListModel.SourceItem res : call.getResults()) {
                    LOGGER.debug("Kodi datasource: {}", (Object)res.file);
                    this.videodatasourcesAsString.add(res.file);
                    SplitUri s = new SplitUri(res.file, "", res.label, this.connectionManager.getHostConfig().getAddress());
                    this.videodatasources.add(s);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
            Comparator<String> c = Comparator.comparingInt(String::length).thenComparing(Comparator.reverseOrder());
            this.videodatasourcesAsString.sort(c);
        }
    }

    private String detectDatasource(String file) {
        for (String ds : this.videodatasourcesAsString) {
            if (!file.startsWith(ds)) continue;
            return ds;
        }
        return "";
    }

    protected void getAndSetMovieMappings() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies(new String[]{"file", "imdbnumber", "title", "year"});
        this.send((AbstractCall<?>)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            Map<SplitUri, Movie> tmmFiles = this.prepareMovieFileMap(MovieModuleManager.getInstance().getMovieList().getMovies());
            Map<String, Movie> imdbIds = this.prepareMovieImdbIdMap(MovieModuleManager.getInstance().getMovieList().getMovies());
            Map<String, List<Movie>> titles = this.prepareMovieTitleMap(MovieModuleManager.getInstance().getMovieList().getMovies());
            LOGGER.debug("TMM {} items", (Object)tmmFiles.size());
            try {
                for (VideoModel.MovieDetail res : call.getResults()) {
                    Movie foundMovie = this.findMatchingMovie(res, tmmFiles, imdbIds, titles);
                    if (foundMovie == null) continue;
                    this.moviemappings.put(foundMovie.getDbId(), res.movieid);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
            LOGGER.debug("mapped {} items", (Object)this.moviemappings.size());
        }
    }

    private Map<SplitUri, Movie> prepareMovieFileMap(List<Movie> movies) {
        HashMap<SplitUri, Movie> fileMap = new HashMap<SplitUri, Movie>();
        for (Movie movie : movies) {
            MediaFile main = movie.getMainVideoFile();
            if (movie.isDisc()) {
                for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!mf.getFilename().equalsIgnoreCase("VIDEO_TS.IFO") && !mf.getFilename().equalsIgnoreCase("INDEX.BDMV")) continue;
                    fileMap.put(new SplitUri(movie.getDataSource(), mf.getFileAsPath().toString()), movie);
                }
                continue;
            }
            fileMap.put(new SplitUri(movie.getDataSource(), main.getFileAsPath().toString()), movie);
        }
        return fileMap;
    }

    private Map<String, Movie> prepareMovieImdbIdMap(List<Movie> movies) {
        HashMap<String, Movie> imdbIdMap = new HashMap<String, Movie>();
        for (Movie movie : movies) {
            if (!MetadataUtil.isValidImdbId(movie.getImdbId())) continue;
            imdbIdMap.put(movie.getImdbId(), movie);
        }
        return imdbIdMap;
    }

    private Map<String, List<Movie>> prepareMovieTitleMap(List<Movie> movies) {
        HashMap<String, List<Movie>> titleMap = new HashMap<String, List<Movie>>();
        for (Movie movie : movies) {
            if (!StringUtils.isNotBlank((CharSequence)movie.getTitle())) continue;
            List moviesForTitle = titleMap.computeIfAbsent(movie.getTitle(), k -> new ArrayList());
            moviesForTitle.add(movie);
        }
        return titleMap;
    }

    private Movie findMatchingMovie(VideoModel.MovieDetail movieDetail, Map<SplitUri, Movie> tmmFiles, Map<String, Movie> imdbIdMap, Map<String, List<Movie>> titleMap) {
        List<Movie> foundMovies;
        Movie foundMovie;
        if (movieDetail.file.startsWith("stack")) {
            String[] files = movieDetail.file.split(" , ");
            for (String s : files) {
                s = s.replaceFirst("^stack://", "");
                String ds = this.detectDatasource(s);
                SplitUri sp = new SplitUri(ds, s, movieDetail.label, this.connectionManager.getHostConfig().getAddress());
                for (Map.Entry<SplitUri, Movie> entry : tmmFiles.entrySet()) {
                    SplitUri tmmsp = entry.getKey();
                    if (!sp.equals(tmmsp)) continue;
                    return entry.getValue();
                }
            }
        } else {
            String ds = this.detectDatasource(movieDetail.file);
            SplitUri kodi = new SplitUri(ds, movieDetail.file, movieDetail.label, this.connectionManager.getHostConfig().getAddress());
            for (Map.Entry<SplitUri, Movie> entry : tmmFiles.entrySet()) {
                SplitUri tmm = entry.getKey();
                if (!kodi.equals(tmm)) continue;
                return entry.getValue();
            }
        }
        if (MetadataUtil.isValidImdbId(movieDetail.imdbnumber) && (foundMovie = imdbIdMap.get(movieDetail.imdbnumber)) != null) {
            return foundMovie;
        }
        if (StringUtils.isNotBlank((CharSequence)movieDetail.title) && ListUtils.isNotEmpty(foundMovies = titleMap.get(movieDetail.imdbnumber))) {
            for (Movie movie : foundMovies) {
                if (!movieDetail.title.equalsIgnoreCase(movie.getTitle()) || movieDetail.year.intValue() != movie.getYear()) continue;
                return movie;
            }
            return foundMovies.get(0);
        }
        return null;
    }

    protected void getAndSetTvShowMappings() {
        VideoLibrary.GetTVShows tvShowCall = new VideoLibrary.GetTVShows(new String[]{"file", "imdbnumber", "title", "year"});
        this.send((AbstractCall<?>)tvShowCall);
        if (tvShowCall.getResults() != null && !tvShowCall.getResults().isEmpty()) {
            Map<SplitUri, TvShow> tmmFiles = this.prepareTvShowFileMap(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
            Map<String, TvShow> idMap = this.prepareTvShowIdMap(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
            LOGGER.debug("TMM {} items", (Object)tmmFiles.size());
            try {
                for (VideoModel.TVShowDetail show : tvShowCall.getResults()) {
                    TvShow foundTvShow = this.findMatchingTvShow(show, tmmFiles, idMap);
                    if (foundTvShow == null) continue;
                    this.tvshowmappings.put(foundTvShow.getDbId(), show.tvshowid);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
            LOGGER.debug("mapped {} items", (Object)this.tvshowmappings.size());
        }
    }

    private Map<SplitUri, TvShow> prepareTvShowFileMap(List<TvShow> tvShows) {
        HashMap<SplitUri, TvShow> fileMap = new HashMap<SplitUri, TvShow>();
        for (TvShow show : tvShows) {
            fileMap.put(new SplitUri(show.getDataSource(), show.getPathNIO().toString()), show);
        }
        return fileMap;
    }

    private Map<String, TvShow> prepareTvShowIdMap(List<TvShow> tvShows) {
        HashMap<String, TvShow> idMap = new HashMap<String, TvShow>();
        for (TvShow tvShow : tvShows) {
            if (MetadataUtil.isValidImdbId(tvShow.getImdbId())) {
                idMap.put(tvShow.getImdbId(), tvShow);
            }
            if (MetadataUtil.parseInt(tvShow.getTvdbId(), 0) <= 0) continue;
            idMap.put(tvShow.getTvdbId(), tvShow);
        }
        return idMap;
    }

    private TvShow findMatchingTvShow(VideoModel.TVShowDetail tvShowDetail, Map<SplitUri, TvShow> tmmFiles, Map<String, TvShow> idMap) {
        TvShow tvShow;
        if (tvShowDetail.file.startsWith("stack")) {
            String[] files;
            for (String s : files = tvShowDetail.file.split(" , ")) {
                s = s.replaceFirst("^stack://", "");
                String ds = this.detectDatasource(s);
                SplitUri sp = new SplitUri(ds, s, tvShowDetail.label, this.connectionManager.getHostConfig().getAddress());
                for (Map.Entry<SplitUri, TvShow> entry : tmmFiles.entrySet()) {
                    SplitUri tmmsp = entry.getKey();
                    if (!sp.equals(tmmsp)) continue;
                    return entry.getValue();
                }
            }
        } else {
            String ds = this.detectDatasource(tvShowDetail.file);
            SplitUri kodi = new SplitUri(ds, tvShowDetail.file, tvShowDetail.label, this.connectionManager.getHostConfig().getAddress());
            for (Map.Entry<SplitUri, TvShow> entry : tmmFiles.entrySet()) {
                SplitUri tmm = entry.getKey();
                if (!kodi.equals(tmm)) continue;
                return entry.getValue();
            }
        }
        if ((MetadataUtil.isValidImdbId(tvShowDetail.imdbnumber) || MetadataUtil.parseInt(tvShowDetail.imdbnumber, 0) > 0) && (tvShow = idMap.get(tvShowDetail.imdbnumber)) != null) {
            return tvShow;
        }
        return null;
    }

    public void refreshFromNfo(Movie movie) {
        Integer kodiID = this.moviemappings.get(movie.getDbId());
        if (kodiID != null) {
            List<MediaFile> nfo = movie.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)movie.getTitle());
            }
            VideoLibrary.RefreshMovie call = new VideoLibrary.RefreshMovie(kodiID, Boolean.valueOf(false));
            this.sendWoResponse((AbstractCall<?>)call);
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)movie.getTitle(), (Object)movie.getDbId());
        }
    }

    public void refreshFromNfo(TvShow tvShow) {
        Integer kodiID = this.tvshowmappings.get(tvShow.getDbId());
        if (kodiID != null) {
            List<MediaFile> nfo = tvShow.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)tvShow.getTitle());
            }
            VideoLibrary.RefreshTVShow call = new VideoLibrary.RefreshTVShow(kodiID, Boolean.valueOf(false), Boolean.valueOf(true));
            this.sendWoResponse((AbstractCall<?>)call);
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)tvShow.getTitle(), (Object)tvShow.getDbId());
        }
    }

    public void refreshFromNfo(TvShowEpisode episode) {
        Integer kodiID = this.getEpisodeId(episode);
        if (kodiID != null) {
            List<MediaFile> nfo = episode.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)episode.getTitle());
            }
            VideoLibrary.RefreshEpisode call = new VideoLibrary.RefreshEpisode(kodiID, Boolean.valueOf(false));
            this.sendWoResponse((AbstractCall<?>)call);
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)episode.getTitle(), (Object)episode.getDbId());
        }
    }

    public void readWatchedState(Movie movie) {
        Integer kodiID = this.moviemappings.get(movie.getDbId());
        if (kodiID != null) {
            VideoLibrary.GetMovieDetails call = new VideoLibrary.GetMovieDetails(kodiID, new String[]{"playcount"});
            this.send((AbstractCall<?>)call);
            if (call.getResult() != null && ((VideoModel.MovieDetail)call.getResult()).playcount != null) {
                movie.setPlaycount(((VideoModel.MovieDetail)call.getResult()).playcount);
                if (((VideoModel.MovieDetail)call.getResult()).playcount > 0) {
                    movie.setWatched(true);
                }
            }
        } else {
            LOGGER.error("Unable get playcount - could not map '{}' to Kodi library! {}", (Object)movie.getTitle(), (Object)movie.getDbId());
        }
    }

    public void readWatchedState(TvShowEpisode episode) {
        Integer kodiID = this.getEpisodeId(episode);
        if (kodiID != null) {
            VideoLibrary.GetEpisodeDetails call = new VideoLibrary.GetEpisodeDetails(kodiID, new String[]{"playcount"});
            this.send((AbstractCall<?>)call);
            if (call.getResult() != null && ((VideoModel.EpisodeDetail)call.getResult()).playcount != null) {
                episode.setPlaycount(((VideoModel.EpisodeDetail)call.getResult()).playcount);
                if (((VideoModel.EpisodeDetail)call.getResult()).playcount > 0) {
                    episode.setWatched(true);
                }
            }
        } else {
            LOGGER.error("Unable get playcount - could not map '{}' to Kodi library! {}", (Object)episode.getTitle(), (Object)episode.getDbId());
        }
    }

    private Integer getEpisodeId(TvShowEpisode episode) {
        Integer tvShowId = this.tvshowmappings.get(episode.getTvShowDbId());
        if (tvShowId == null) {
            return null;
        }
        VideoLibrary.GetEpisodes episodeCall = new VideoLibrary.GetEpisodes(tvShowId, new String[]{"file", "season", "episode", "title"});
        this.send((AbstractCall<?>)episodeCall);
        if (episodeCall.getResults() != null && !episodeCall.getResults().isEmpty()) {
            return this.findMatchingEpisode(episode, episodeCall.getResults());
        }
        return null;
    }

    private Integer findMatchingEpisode(TvShowEpisode episode, List<VideoModel.EpisodeDetail> episodeDetails) {
        MediaFile main = episode.getMainVideoFile();
        SplitUri splitUri = null;
        if (episode.isDisc()) {
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO)) {
                if (!mf.getFilename().equalsIgnoreCase("VIDEO_TS.IFO") && !mf.getFilename().equalsIgnoreCase("INDEX.BDMV")) continue;
                splitUri = new SplitUri(episode.getDataSource(), mf.getFileAsPath().toString());
            }
        } else {
            splitUri = new SplitUri(episode.getDataSource(), main.getFileAsPath().toString());
        }
        if (splitUri != null) {
            for (VideoModel.EpisodeDetail episodeDetail : episodeDetails) {
                if (episodeDetail.file.startsWith("stack")) {
                    String[] files;
                    for (String s : files = episodeDetail.file.split(" , ")) {
                        String ds = this.detectDatasource(s = s.replaceFirst("^stack://", ""));
                        SplitUri sp = new SplitUri(ds, s, episodeDetail.label, this.connectionManager.getHostConfig().getAddress());
                        if (!sp.equals(splitUri)) continue;
                        return episodeDetail.episodeid;
                    }
                    continue;
                }
                String ds = this.detectDatasource(episodeDetail.file);
                SplitUri kodi = new SplitUri(ds, episodeDetail.file, episodeDetail.label, this.connectionManager.getHostConfig().getAddress());
                if (!kodi.equals(splitUri)) continue;
                return episodeDetail.episodeid;
            }
        }
        if (episode.getSeason() > -1 && episode.getEpisode() > -1) {
            for (VideoModel.EpisodeDetail episodeDetail : episodeDetails) {
                if (episodeDetail.season.intValue() != episode.getSeason() || episodeDetail.episode.intValue() != episode.getEpisode()) continue;
                return episodeDetail.episodeid;
            }
        }
        return null;
    }

    public void cleanAudioLibrary() {
        AudioLibrary.Clean call = new AudioLibrary.Clean(Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanAudioLibrary() {
        AudioLibrary.Scan call = new AudioLibrary.Scan(null);
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanAudioLibrary(String dir) {
        AudioLibrary.Scan call = new AudioLibrary.Scan(dir);
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public List<SplitUri> getAudioDataSources() {
        return this.audiodatasources;
    }

    private void getAndSetAudioDataSources() {
        Files.GetSources call = new Files.GetSources("music");
        this.audiodatasources.clear();
        this.send((AbstractCall<?>)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            try {
                for (ListModel.SourceItem res : call.getResults()) {
                    this.audiodatasources.add(new SplitUri(res.file, res.file, res.label, this.connectionManager.getHostConfig().getAddress()));
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
        }
    }

    public String getKodiVersion() {
        Application.GetProperties call = new Application.GetProperties(new String[]{"version"});
        this.send((AbstractCall<?>)call);
        try {
            ApplicationModel.PropertyValue res = (ApplicationModel.PropertyValue)call.getResult();
            int maj = res.version.major;
            int min = res.version.minor;
            return maj + "." + min;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void quitApplication() {
        Application.Quit call = new Application.Quit();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void muteApplication() {
        Application.GetProperties props = new Application.GetProperties(new String[]{"muted"});
        this.send((AbstractCall<?>)props);
        if (props.getResults() != null && !props.getResults().isEmpty()) {
            Application.SetMute call = new Application.SetMute(new GlobalModel.Toggle(Boolean.valueOf(((ApplicationModel.PropertyValue)props.getResult()).muted == false)));
            this.sendWoResponse((AbstractCall<?>)call);
        }
    }

    public void setVolume(int vol) {
        Application.SetVolume call = new Application.SetVolume(Integer.valueOf(vol));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemEjectOpticalDrive() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemHibernate() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemShutdown() {
        System.Shutdown call = new System.Shutdown();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemReboot() {
        System.Reboot call = new System.Reboot();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemSuspend() {
        System.Suspend call = new System.Suspend();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void send(AbstractCall<?> call) {
        if (!this.isConnected()) {
            LOGGER.warn("Cannot send RPC call - not connected");
            return;
        }
        try {
            call.setResponse((JsonNode)JsonApiRequest.execute((HostConfig)this.connectionManager.getHostConfig(), (ObjectNode)call.getRequest()));
        }
        catch (ApiException e) {
            LOGGER.error("Error calling Kodi: {}", (Object)e.getMessage());
        }
    }

    public void sendWoResponse(AbstractCall<?> call) {
        if (!this.isConnected()) {
            LOGGER.warn("Cannot send RPC call - not connected");
            return;
        }
        new Thread(() -> {
            try {
                JsonApiRequest.execute((HostConfig)this.connectionManager.getHostConfig(), (ObjectNode)call.getRequest());
            }
            catch (ApiException e) {
                LOGGER.error("Error calling Kodi: {}", (Object)e.getMessage());
            }
        }).start();
    }

    public void connect(HostConfig config) throws Exception {
        if (this.isConnected()) {
            this.connectionManager.disconnect();
        }
        new Thread(() -> {
            try {
                LOGGER.info("Connecting...");
                this.connectionManager.connect(config);
                if (this.isConnected()) {
                    this.kodiVersion = this.getKodiVersion();
                    this.getAndSetVideoDataSources();
                    this.getAndSetAudioDataSources();
                    this.getAndSetMovieMappings();
                    this.getAndSetTvShowMappings();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error connecting to Kodi - '{}'", (Object)e.getMessage());
            }
        }).start();
    }

    public void connect() {
        Settings s = Settings.getInstance();
        if (s.getKodiHost().isEmpty()) {
            return;
        }
        try {
            this.connect(new HostConfig(s.getKodiHost(), s.getKodiHttpPort(), s.getKodiTcpPort(), s.getKodiUsername(), s.getKodiPassword()));
        }
        catch (Exception cex) {
            LOGGER.error("Error connecting to Kodi instance! {}", (Object)cex.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "KodiRPC", "Could not connect to Kodi: " + cex.getMessage()));
        }
    }

    public void disconnect() {
        this.connectionManager.disconnect();
    }

    public void getDataSources() {
        Settings.getInstance();
        Files.GetSources f = new Files.GetSources("video");
        this.connectionManager.call((AbstractCall)f, (ApiCallback)new ApiCallback<ListModel.SourceItem>(){

            public void onResponse(AbstractCall<ListModel.SourceItem> call) {
                LOGGER.info("found " + call.getResults().size() + " sources");
                LOGGER.info("--- KODI DATASOURCES ---");
                for (ListModel.SourceItem res : call.getResults()) {
                    LOGGER.debug(res.file + " - " + new SplitUri(res.file, "", res.label, KodiRPC.this.connectionManager.getHostConfig().getAddress()));
                }
                LOGGER.info("--- TMM DATASOURCES ---");
                for (String ds : MovieModuleManager.getInstance().getSettings().getMovieDataSource()) {
                    LOGGER.info(ds + " - " + new SplitUri(ds, ""));
                }
                for (String ds : TvShowModuleManager.getInstance().getSettings().getTvShowDataSource()) {
                    LOGGER.info(ds + " - " + new SplitUri(ds, ""));
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void updateMovieMappings() {
        if (this.isConnected()) {
            this.getAndSetMovieMappings();
        }
    }

    public void updateTvShowMappings() {
        if (this.isConnected()) {
            this.getAndSetTvShowMappings();
        }
    }

    public List<VideoModel.MovieDetail> getAllMoviesSYNC() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies(new String[]{"file"});
        this.send((AbstractCall<?>)call);
        return call.getResults();
    }

    public void getAllMoviesASYNC() {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies(new String[]{"file"});
        this.connectionManager.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.MovieDetail>(){

            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void triggerReload(Movie movie) {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies(new String[]{"file"});
        this.connectionManager.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.MovieDetail>(){

            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void getAllTvShows() {
        VideoLibrary.GetTVShows vl = new VideoLibrary.GetTVShows(new String[0]);
        this.connectionManager.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.TVShowDetail>(){

            public void onResponse(AbstractCall<VideoModel.TVShowDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " shows");
                for (VideoModel.TVShowDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }
}

