/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;

public class MovieSyncTraktTvTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSyncTraktTvTask.class);
    private final List<Movie> movies = new ArrayList<Movie>();
    private boolean syncCollection = false;
    private boolean syncWatched = false;
    private boolean syncRating = false;

    public MovieSyncTraktTvTask(List<Movie> movies) {
        super(TmmResourceBundle.getString("trakt.sync"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.movies.addAll(movies);
    }

    public void setSyncCollection(boolean value) {
        this.syncCollection = value;
    }

    public void setSyncWatched(boolean value) {
        this.syncWatched = value;
    }

    public void setSyncRating(boolean value) {
        this.syncRating = value;
    }

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        TraktTv traktTV = TraktTv.getInstance();
        if (this.syncCollection) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.movie"), 0);
            try {
                traktTV.syncTraktMovieCollection(this.movies);
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncWatched) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.moviewatched"), 0);
            try {
                traktTV.syncTraktMovieWatched(this.movies);
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncRating) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.movierating"), 0);
            try {
                traktTV.syncTraktMovieRating(this.movies);
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
    }
}

