/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.yt;

import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.request.RequestVideoFileDownload;
import com.github.kiulian.downloader.downloader.request.RequestVideoStreamDownload;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.Response;
import com.github.kiulian.downloader.downloader.response.ResponseImpl;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.http.Url;

class DownloaderImpl
implements Downloader {
    private static final MediaType JSON = MediaType.parse((String)"application/json");

    DownloaderImpl() {
    }

    public Response<String> downloadWebpage(RequestWebpage requestWebpage) {
        if ("POST".equals(requestWebpage.getMethod())) {
            return this.post(requestWebpage);
        }
        return this.get(requestWebpage);
    }

    private Response<String> get(RequestWebpage requestWebpage) {
        try {
            Url url = new Url(requestWebpage.getDownloadUrl());
            if (requestWebpage.getHeaders() != null) {
                for (Map.Entry entry : requestWebpage.getHeaders().entrySet()) {
                    url.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            String body = requestWebpage.getMaxRetries() != null ? new String(url.getBytesWithRetry(requestWebpage.getMaxRetries()), StandardCharsets.UTF_8) : new String(url.getBytes(), StandardCharsets.UTF_8);
            return ResponseImpl.from((Object)body);
        }
        catch (Exception e) {
            return ResponseImpl.error((Throwable)e);
        }
    }

    private Response<String> post(RequestWebpage requestWebpage) {
        Call call = null;
        okhttp3.Response response = null;
        try {
            RequestBody body = RequestBody.create((String)requestWebpage.getBody(), (MediaType)JSON);
            Request.Builder builder = new Request.Builder().url(requestWebpage.getDownloadUrl()).post(body);
            if (requestWebpage.getHeaders() != null) {
                for (Map.Entry entry : requestWebpage.getHeaders().entrySet()) {
                    builder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            Request request = builder.build();
            call = TmmHttpClient.getHttpClient().newCall(request);
            response = call.execute();
            int responseCode = response.code();
            String responseMessage = response.message();
            if (responseCode < 200 || responseCode >= 400) {
                throw new HttpException(requestWebpage.getBody(), responseCode, responseMessage);
            }
            return ResponseImpl.from((Object)response.body().string());
        }
        catch (Exception e) {
            if (call != null) {
                call.cancel();
            }
            if (response != null) {
                response.close();
            }
            return ResponseImpl.error((Throwable)e);
        }
    }

    public Response<File> downloadVideoAsFile(RequestVideoFileDownload requestVideoFileDownload) {
        return null;
    }

    public Response<Void> downloadVideoAsStream(RequestVideoStreamDownload requestVideoStreamDownload) {
        return null;
    }
}

