/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.table.TmmTable;

public class TmmUILayoutStore
implements AWTEventListener {
    private static TmmUILayoutStore instance;
    private final TmmProperties properties = TmmProperties.getInstance();
    private final Set<String> componentSet = new HashSet<String>();

    private TmmUILayoutStore() {
    }

    public static synchronized TmmUILayoutStore getInstance() {
        if (instance == null) {
            instance = new TmmUILayoutStore();
        }
        return instance;
    }

    public void install(JComponent component) {
        if (StringUtils.isBlank((CharSequence)component.getName())) {
            return;
        }
        if (component instanceof JSplitPane) {
            this.installJSplitPane((JSplitPane)component);
        } else if (component instanceof TmmTable) {
            this.installTmmTable((TmmTable)component);
        }
    }

    private void installJSplitPane(JSplitPane splitPane) {
        String componentName = splitPane.getName();
        this.componentSet.add(componentName);
        int dividerLocation = this.properties.getPropertyAsInteger(componentName + ".dividerLocation");
        if (dividerLocation > 0) {
            splitPane.setDividerLocation(dividerLocation);
        }
    }

    private void installTmmTable(TmmTable table) {
        String componentName = table.getName();
        this.componentSet.add(componentName);
        String hiddenColumnsAsString = this.properties.getProperty(componentName + ".hiddenColumns");
        if (StringUtils.isNotBlank((CharSequence)hiddenColumnsAsString)) {
            List<String> hiddenColumns = Arrays.asList(hiddenColumnsAsString.split(","));
            table.readHiddenColumns(hiddenColumns);
            if (table.getTableComparatorChooser() != null) {
                table.getTableComparatorChooser().fromString(this.properties.getProperty(componentName + ".sortState"));
            }
        } else if (hiddenColumnsAsString == null) {
            table.setDefaultHiddenColumns();
        }
    }

    public void loadSettings(JFrame frame) {
        if (!Settings.getInstance().isStoreWindowPreferences()) {
            if ("mainWindow".equals(frame.getName())) {
                frame.setLocationRelativeTo(null);
            }
            return;
        }
        if ("mainWindow".equals(frame.getName())) {
            Rectangle rect = this.getWindowBounds("mainWindow");
            if (rect.width > 0) {
                GraphicsDevice ge = this.getScreenForBounds(rect);
                if (ge.getDefaultConfiguration() != frame.getGraphicsConfiguration()) {
                    JFrame dummy = new JFrame(ge.getDefaultConfiguration());
                    frame.setLocationRelativeTo(dummy);
                    dummy.dispose();
                }
                frame.setBounds(rect);
                if (Boolean.TRUE.equals(this.properties.getPropertyAsBoolean("mainWindowMaximized"))) {
                    frame.setExtendedState(frame.getExtendedState() | 6);
                    frame.validate();
                }
            } else {
                frame.setLocationRelativeTo(null);
            }
        }
    }

    public void loadSettings(JDialog dialog) {
        if (!Settings.getInstance().isStoreWindowPreferences() || StringUtils.isBlank((CharSequence)dialog.getName())) {
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
            return;
        }
        if (!dialog.getName().contains("dialog")) {
            Rectangle rect = this.getWindowBounds(dialog.getName());
            if (rect.width == 0 && rect.height == 0) {
                dialog.pack();
                dialog.setLocationRelativeTo(dialog.getParent());
                return;
            }
            Dimension minimumSize = dialog.getMinimumSize();
            if (rect.width < minimumSize.width) {
                rect.width = minimumSize.width;
            }
            if (rect.height < minimumSize.height) {
                rect.height = minimumSize.height;
            }
            if (rect.width > 0 && this.getVirtualBounds().contains(rect)) {
                GraphicsDevice ge = this.getScreenForBounds(rect);
                if (ge.getDefaultConfiguration() != dialog.getGraphicsConfiguration()) {
                    JFrame dummy = new JFrame(ge.getDefaultConfiguration());
                    dialog.setLocationRelativeTo(dummy);
                    dummy.dispose();
                }
                dialog.setBounds(rect);
            } else {
                dialog.pack();
                dialog.setLocationRelativeTo(dialog.getParent());
            }
        } else {
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
        }
    }

    private GraphicsDevice getScreenForBounds(Rectangle rectangle) {
        GraphicsDevice[] gs;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!bounds.contains(rectangle)) continue;
            return device;
        }
        return ge.getDefaultScreenDevice();
    }

    public void saveSettings(JFrame frame) {
        if (!Settings.getInstance().isStoreWindowPreferences()) {
            return;
        }
        if ("mainWindow".equals(frame.getName()) && frame instanceof MainWindow) {
            if ((frame.getExtendedState() & 6) == 6) {
                this.storeWindowBounds("mainWindow", frame.getGraphicsConfiguration().getBounds());
                this.addParam("mainWindowMaximized", true);
            } else {
                this.storeWindowBounds("mainWindow", frame.getBounds());
                this.addParam("mainWindowMaximized", false);
            }
        }
        this.saveChildren(frame);
    }

    private void saveChildren(Container container) {
        Component[] comps;
        for (Component comp : comps = container.getComponents()) {
            if (this.componentSet.contains(comp.getName()) && comp instanceof JComponent && this.componentSet.contains(comp.getName())) {
                this.saveComponent(comp);
            }
            if (!(comp instanceof Container)) continue;
            this.saveChildren((Container)comp);
        }
    }

    private void saveComponent(Component component) {
        if (component instanceof JSplitPane) {
            this.saveJSplitPane((JSplitPane)component);
        } else if (component instanceof TmmTable) {
            this.saveTmmTable((TmmTable)component);
        }
    }

    private void saveJSplitPane(JSplitPane splitPane) {
        String componentName = splitPane.getName();
        this.addParam(componentName + ".dividerLocation", splitPane.getDividerLocation());
    }

    private void saveTmmTable(TmmTable table) {
        String componentName = table.getName();
        this.addParam(componentName + ".hiddenColumns", String.join((CharSequence)",", table.getHiddenColumns()));
        if (table.getTableComparatorChooser() != null) {
            this.addParam(componentName + ".sortState", table.getTableComparatorChooser().toString());
        }
    }

    public void saveSettings(JDialog dialog) {
        if (!Settings.getInstance().isStoreWindowPreferences() || StringUtils.isBlank((CharSequence)dialog.getName())) {
            return;
        }
        if (!dialog.getName().contains("dialog")) {
            this.storeWindowBounds(dialog.getName(), dialog.getBounds());
        }
        this.saveChildren(dialog);
    }

    private void storeWindowBounds(String name, Rectangle bounds) {
        this.addParam(name + ".bounds", bounds.x + "," + bounds.y + "," + bounds.width + "," + bounds.height);
    }

    private Rectangle getWindowBounds(String name) {
        GraphicsDevice[] gs;
        Rectangle rect = new Rectangle();
        String boundsAsString = this.properties.getProperty(name + ".bounds");
        if (StringUtils.isBlank((CharSequence)boundsAsString)) {
            return rect;
        }
        try {
            String[] parts = boundsAsString.split(",");
            rect.x = Integer.parseInt(parts[0]);
            rect.y = Integer.parseInt(parts[1]);
            rect.width = Integer.parseInt(parts[2]);
            rect.height = Integer.parseInt(parts[3]);
        }
        catch (Exception e) {
            return rect;
        }
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!bounds.contains(rect)) continue;
            graphicsConfiguration = gc;
            break;
        }
        if (graphicsConfiguration == null) {
            graphicsConfiguration = ge.getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        if (rect.x - scnMax.left + rect.width > screenBounds.x + screenBounds.width - scnMax.right) {
            rect.x = screenBounds.x + scnMax.left;
            rect.width = screenBounds.width - scnMax.right;
        }
        if (rect.y - scnMax.top + rect.height > screenBounds.y + screenBounds.height - scnMax.bottom) {
            rect.y = screenBounds.y + scnMax.top;
            rect.height = screenBounds.height - scnMax.bottom;
        }
        return rect;
    }

    private void addParam(String key, Object value) {
        this.properties.putProperty(key, value.toString());
    }

    private Rectangle getVirtualBounds() {
        GraphicsDevice[] lstGDs;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : lstGDs = ge.getScreenDevices()) {
            bounds.add(gd.getDefaultConfiguration().getBounds());
        }
        return bounds;
    }

    @Override
    public void eventDispatched(AWTEvent evt) {
        ComponentEvent cev = (ComponentEvent)evt;
        if (evt.getID() == 201 && cev.getComponent() instanceof JFrame) {
            JFrame frame = (JFrame)cev.getComponent();
            this.saveSettings(frame);
        }
        if (evt.getID() == 202 && cev.getComponent() instanceof JDialog) {
            JDialog dialog = (JDialog)cev.getComponent();
            this.saveSettings(dialog);
        }
    }
}

