/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class ClearDatabaseAction
extends TmmAction {
    private static final long serialVersionUID = 5840749350843921771L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearDatabaseAction.class);

    public ClearDatabaseAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.cleardatabase"));
    }

    @Override
    protected void processAction(ActionEvent arg0) {
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.cleardatabase.hint"), TmmResourceBundle.getString("tmm.cleardatabase"), 3, 0, null, options, null);
        if (answer != 0) {
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            TmmModuleManager.getInstance().shutDown();
            TmmModuleManager.getInstance().initializeDatabase();
            MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.cleardatabase.info"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.cleardatabase.error"));
            Path path = Paths.get("", new String[0]);
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    TmmUIHelper.openFile(path);
                }
            }
            catch (Exception ex) {
                LOGGER.warn(ex.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
            }
        }
        MainWindow.getInstance().closeTmmAndStart(TmmOsUtils.getPBforTMMrestart());
    }
}

