/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class ExportLogAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportLogAction.class);
    private static final long serialVersionUID = -1578568721825387890L;

    public ExportLogAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.exportlogs"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path file = null;
        try {
            String path = TmmProperties.getInstance().getProperty("exportlogs.path", "");
            file = TmmUIHelper.saveFile(TmmResourceBundle.getString("BugReport.savelogs"), path, "tmm_logs.zip", new FileNameExtensionFilter("Zip files", ".zip"));
            if (file != null) {
                this.writeLogsFile(file.toFile());
                TmmProperties.getInstance().putProperty("exportlogs.path", file.toAbsolutePath().toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not write logs.zip: {}", (Object)ex.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)(file != null ? file.toString() : ""), "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
        }
    }

    private void writeLogsFile(File file) throws Exception {
        block43: {
            try (FileOutputStream os = new FileOutputStream(file);
                 ZipOutputStream zos = new ZipOutputStream(os);){
                try (FileInputStream in = new FileInputStream("logs" + File.separator + "trace.log");){
                    File[] ze = new ZipEntry("trace.log");
                    zos.putNextEntry((ZipEntry)ze);
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    zos.closeEntry();
                }
                catch (Exception e) {
                    LOGGER.warn("could not append trace file to the zip file: {}", (Object)e.getMessage());
                }
                File[] logs = new File("logs").listFiles(new FilenameFilter(){
                    Pattern logPattern = Pattern.compile("tmm\\.log\\.*");

                    @Override
                    public boolean accept(File directory, String filename) {
                        Matcher matcher = this.logPattern.matcher(filename);
                        return matcher.find();
                    }
                });
                if (logs != null) {
                    for (File logFile : logs) {
                        try (FileInputStream in = new FileInputStream(logFile);){
                            ZipEntry ze = new ZipEntry(logFile.getName());
                            zos.putNextEntry(ze);
                            IOUtils.copy((InputStream)in, (OutputStream)zos);
                            zos.closeEntry();
                        }
                        catch (Exception e) {
                            LOGGER.warn("unable to attach {} - {}", (Object)logFile.getName(), (Object)e.getMessage());
                        }
                    }
                }
                try (FileInputStream in = new FileInputStream("launcher.log");){
                    ZipEntry ze = new ZipEntry("launcher.log");
                    zos.putNextEntry(ze);
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    in.close();
                    zos.closeEntry();
                }
                catch (Exception e) {
                    LOGGER.warn("unable to attach launcher.log: {}", (Object)e.getMessage());
                }
                File[] data = new File(Globals.DATA_FOLDER).listFiles((directory, filename) -> !filename.matches(".*\\.db$") && !filename.contains("tmm.lic"));
                if (data == null) break block43;
                for (File dataFile : data) {
                    try (FileInputStream in = new FileInputStream(dataFile);){
                        ZipEntry ze = new ZipEntry(dataFile.getName());
                        zos.putNextEntry(ze);
                        IOUtils.copy((InputStream)in, (OutputStream)zos);
                        zos.closeEntry();
                    }
                    catch (Exception e) {
                        LOGGER.warn("unable to attach {} - {}", (Object)dataFile.getName(), (Object)e.getMessage());
                    }
                }
            }
        }
    }
}

