/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.actions.TmmAction;

public class RebuildImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = -9178351750617647813L;

    public RebuildImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.rebuildimagecache"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Settings.getInstance().isImageCache()) {
            JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.imagecache.notactivated"));
            return;
        }
        ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
        ArrayList<Movie> movies = new ArrayList<Movie>(MovieModuleManager.getInstance().getMovieList().getMovies());
        for (Movie movie : movies) {
            imageFiles.addAll(movie.getImagesToCache());
        }
        ArrayList<MovieSet> movieSets = new ArrayList<MovieSet>(MovieModuleManager.getInstance().getMovieList().getMovieSetList());
        for (MovieSet movieSet : movieSets) {
            imageFiles.addAll(movieSet.getImagesToCache());
        }
        ArrayList<TvShow> arrayList = new ArrayList<TvShow>(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
        for (TvShow tvShow : arrayList) {
            imageFiles.addAll(tvShow.getImagesToCache());
        }
        ImageCacheTask imageCacheTask = new ImageCacheTask(imageFiles);
        TmmTaskManager.getInstance().addUnnamedTask(imageCacheTask);
    }
}

