/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.license.TmmFeature;

public abstract class TmmAction
extends AbstractAction
implements TmmFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmAction.class);

    @Override
    public final void actionPerformed(ActionEvent e) {
        LOGGER.debug("action fired: {}", (Object)this.getClass().getSimpleName());
        if (this.isEnabled()) {
            this.processAction(e);
        }
    }

    @Override
    public final Object getValue(String key) {
        switch (key) {
            case "enabled": {
                return this.isEnabled();
            }
            case "Name": 
            case "ShortDescription": {
                Object value = super.getValue(key);
                if (value != null && !this.isEnabled()) {
                    return "*PRO* " + value.toString();
                }
                return value;
            }
        }
        return super.getValue(key);
    }

    @Override
    public final boolean isEnabled() {
        return this.isFeatureEnabled();
    }

    protected abstract void processAction(ActionEvent var1);
}

