/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.WritableTableFormat;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.ui.NumberCellEditor;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;

public class MediaRatingTable
extends TmmTable {
    private static final long serialVersionUID = 8010732881277204728L;
    private final Map<String, MediaRating> ratingMap;
    private final EventList<Rating> ratingList;

    public MediaRatingTable(Map<String, MediaRating> ratings) {
        this.ratingMap = ratings;
        this.ratingList = MediaRatingTable.convertRatingMapToEventList(this.ratingMap, true);
        this.setModel((TableModel)((Object)new TmmTableModel<Rating>(this.ratingList, new MediaRatingTableFormat(false))));
        this.setTableHeader(null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public MediaRatingTable(EventList<Rating> ratings) {
        this.ratingMap = null;
        this.ratingList = ratings;
        this.setModel((TableModel)((Object)new TmmTableModel<Rating>(this.ratingList, new MediaRatingTableFormat(true))));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn column = this.getColumnModel().getColumn(1);
        column.setCellEditor(new NumberCellEditor(3, 2));
        column = this.getColumnModel().getColumn(2);
        column.setCellEditor(new NumberCellEditor(3, 0));
        column = this.getColumnModel().getColumn(3);
        column.setCellEditor(new NumberCellEditor(10, 0));
    }

    public static EventList<Rating> convertRatingMapToEventList(Map<String, MediaRating> idMap, boolean withUserRating) {
        BasicEventList idList = new BasicEventList();
        for (Map.Entry<String, MediaRating> entry : idMap.entrySet()) {
            if ("user".equals(entry.getKey()) && !withUserRating) continue;
            Rating id = new Rating(entry.getKey());
            MediaRating mediaRating = entry.getValue();
            id.value = mediaRating.getRating();
            id.votes = mediaRating.getVotes();
            id.maxValue = mediaRating.getMaxValue();
            idList.add((Object)id);
        }
        return idList;
    }

    public static EventList<Rating> convertRatingMapToEventList(List<MediaRating> ratings) {
        BasicEventList idList = new BasicEventList();
        for (MediaRating rating : ratings) {
            Rating id = new Rating(rating.getId());
            MediaRating mediaRating = rating;
            id.value = mediaRating.getRating();
            id.votes = mediaRating.getVotes();
            id.maxValue = mediaRating.getMaxValue();
            idList.add((Object)id);
        }
        return idList;
    }

    private class MediaRatingTableFormat
    extends TmmTableFormat<Rating>
    implements WritableTableFormat<Rating> {
        private final boolean editable;

        MediaRatingTableFormat(boolean editable) {
            this.editable = editable;
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating.source"), "source", rating -> rating.key, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating"), "rating", rating -> Float.valueOf(rating.value), Float.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating.maxvalue"), "maxvalue", rating -> rating.maxValue, Integer.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating.votes"), "votes", rating -> rating.votes, Integer.class);
            this.addColumn(col);
        }

        public boolean isEditable(Rating arg0, int arg1) {
            return this.editable;
        }

        public Rating setColumnValue(Rating arg0, Object arg1, int arg2) {
            if (arg0 == null || arg1 == null) {
                return null;
            }
            switch (arg2) {
                case 0: {
                    arg0.key = arg1.toString();
                    break;
                }
                case 1: {
                    try {
                        arg0.value = ((Float)arg1).floatValue();
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    try {
                        arg0.maxValue = (Integer)arg1;
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 3: {
                    try {
                        arg0.votes = (Integer)arg1;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return arg0;
        }
    }

    public static class Rating {
        public String key;
        public float value;
        public int maxValue;
        public int votes;

        public Rating(String key) {
            this.key = key;
        }

        public int hashCode() {
            return new HashCodeBuilder(13, 31).append((Object)this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Rating)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Rating other = (Rating)obj;
            return StringUtils.equals((CharSequence)this.key, (CharSequence)other.key);
        }
    }
}

