/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tinymediamanager.ui.IconManager;

public class SplitButton
extends JPanel {
    private static final String uiClassID = "SplitButtonUI";
    protected final JButton actionButton;
    protected final JButton menuButton;
    protected JPopupMenu popupMenu;

    public SplitButton(String text, Icon icon) {
        this.setLayout(new BorderLayout());
        this.actionButton = new JButton(text, icon);
        this.add((Component)this.actionButton, "Center");
        this.menuButton = new JButton(IconManager.ARROW_DOWN_INV);
        this.menuButton.addActionListener(e -> {
            int x = -this.actionButton.getWidth();
            int y = this.menuButton.getHeight();
            this.popupMenu.show(this.menuButton, x, y);
        });
        this.add((Component)this.menuButton, "East");
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setLightWeightPopupEnabled(true);
        this.updateUI();
    }

    public SplitButton(String text) {
        this(text, null);
    }

    public SplitButton(Icon icon) {
        this(null, icon);
    }

    public SplitButton() {
        this(null, null);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JButton getActionButton() {
        return this.actionButton;
    }

    public JButton getMenuButton() {
        return this.menuButton;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

