/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.FlatButton;

public class TaskListComponent
extends JPanel {
    private static final long serialVersionUID = -6088880093610800005L;
    private TmmTaskHandle taskHandle;
    private JLabel mainLabel;
    private JLabel dynaLabel;
    private JProgressBar bar;
    private JButton closeButton;

    public TaskListComponent() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:300lp,grow][]", "[][][][]"));
        this.setOpaque(false);
        this.mainLabel = new JLabel();
        TmmFontHelper.changeFont(this.mainLabel, 1.167, 1);
        this.dynaLabel = new JLabel();
        this.bar = new JProgressBar();
        this.closeButton = new FlatButton(IconManager.CANCEL);
        this.closeButton.addActionListener(e -> this.taskHandle.cancel());
        this.add((Component)this.mainLabel, "cell 0 0,wmin 0");
        this.add((Component)this.bar, "cell 0 1,growx");
        this.add((Component)this.closeButton, "cell 1 1");
        this.add((Component)this.dynaLabel, "cell 0 2,wmin 0");
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 3 2 1,growx");
    }

    public TaskListComponent(String staticText) {
        this();
        this.mainLabel.setText(staticText);
        this.mainLabel.setToolTipText(staticText);
        this.bar.setVisible(false);
        this.closeButton.setVisible(false);
        this.dynaLabel.setVisible(false);
        this.taskHandle = null;
    }

    public TaskListComponent(TmmTaskHandle handle) {
        this();
        this.taskHandle = handle;
        this.updateTaskInformation();
    }

    public void updateTaskInformation() {
        if (this.taskHandle == null) {
            return;
        }
        this.mainLabel.setText(this.taskHandle.getTaskName());
        this.mainLabel.setToolTipText(this.taskHandle.getTaskName());
        switch (this.taskHandle.getState()) {
            case CREATED: 
            case STARTED: {
                if (StringUtils.isNotBlank((CharSequence)this.taskHandle.getTaskDescription())) {
                    this.dynaLabel.setText(this.taskHandle.getTaskDescription());
                    break;
                }
                this.dynaLabel.setText(TmmResourceBundle.getString("task.running"));
                break;
            }
            case QUEUED: {
                this.dynaLabel.setText(TmmResourceBundle.getString("task.queued"));
                break;
            }
            case CANCELLED: {
                this.dynaLabel.setText(TmmResourceBundle.getString("task.cancelled"));
                break;
            }
            case FINISHED: {
                this.dynaLabel.setText(TmmResourceBundle.getString("task.finished"));
                break;
            }
            case FAILED: {
                this.dynaLabel.setText(TmmResourceBundle.getString("task.failed"));
            }
        }
        if (this.taskHandle.getWorkUnits() > 0) {
            this.bar.setValue(this.taskHandle.getProgressDone());
            this.bar.setMaximum(this.taskHandle.getWorkUnits());
            this.bar.setIndeterminate(false);
        } else if (this.taskHandle.getState() == TmmTaskHandle.TaskState.QUEUED) {
            this.bar.setIndeterminate(false);
            this.bar.setValue(0);
            this.bar.setMaximum(1);
        } else {
            this.bar.setIndeterminate(true);
        }
    }

    public TmmTaskHandle getHandle() {
        return this.taskHandle;
    }
}

