/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public class MediaScraperCheckComboBox
extends TmmCheckComboBox<MediaScraper> {
    private static final long serialVersionUID = 8153649858409237947L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaScraperCheckComboBox.class);
    private Map<URI, ImageIcon> imageCache;
    private int listWidth = 0;

    public MediaScraperCheckComboBox(List<MediaScraper> scrapers) {
        super(scrapers);
        if (this.getRenderer() instanceof MediaScraperCheckBoxRenderer) {
            ((MediaScraperCheckBoxRenderer)this.getRenderer()).init(this.checkComboBoxItems);
        }
    }

    @Override
    protected void setRenderer() {
        this.setRenderer(new MediaScraperCheckBoxRenderer());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.imageCache != null) {
            this.imageCache.clear();
        }
    }

    @Override
    public List<MediaScraper> getSelectedItems() {
        ArrayList<MediaScraper> selectedItems = new ArrayList<MediaScraper>();
        for (MediaScraper scraper : super.getSelectedItems()) {
            if (!scraper.getMediaProvider().isActive()) continue;
            selectedItems.add(scraper);
        }
        return selectedItems;
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        dim.width = Math.max(dim.width, this.getPreferredPopupSize().width);
        return dim;
    }

    private Dimension getPreferredPopupSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.listWidth > 0) {
            dimension.width = this.listWidth;
        }
        return dimension;
    }

    private class MediaScraperCheckBoxRenderer
    extends TmmCheckComboBox.CheckBoxRenderer {
        private final JPanel panel;
        private final JCheckBox checkBox;
        private final JLabel label;
        private int maxIconWidth;

        private MediaScraperCheckBoxRenderer() {
            super(MediaScraperCheckComboBox.this);
            this.panel = new JPanel();
            this.checkBox = new JCheckBox();
            this.label = new JLabel();
            this.maxIconWidth = 0;
            this.panel.setLayout(new FlowLayout(0));
            this.panel.add(this.checkBox);
            this.panel.add(this.label);
            this.panel.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            this.label.setOpaque(false);
            this.checkBox.setOpaque(false);
            MediaScraperCheckComboBox.this.imageCache = new HashMap<URI, ImageIcon>();
        }

        private void init(List<TmmCheckComboBoxItem<MediaScraper>> items) {
            for (TmmCheckComboBoxItem<MediaScraper> item : items) {
                ImageIcon logo;
                if (item.getUserObject() == null || (logo = this.getIcon(item.getUserObject().getLogoURL())) == null) continue;
                this.maxIconWidth = Math.max(this.maxIconWidth, logo.getIconWidth());
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TmmCheckComboBoxItem<MediaScraper>> list, TmmCheckComboBoxItem<MediaScraper> value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            if (value != null) {
                TmmCheckComboBoxItem<MediaScraper> cb = value;
                if (cb == MediaScraperCheckComboBox.this.nullItem) {
                    list.setToolTipText(null);
                    return this.separator;
                }
                if (isSelected) {
                    this.panel.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.panel.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.panel.setBackground(UIManager.getColor("ComboBox.background"));
                    this.panel.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                this.label.setText(cb.getText());
                this.checkBox.setSelected(cb.isSelected());
                MediaScraper scraper = cb.getUserObject();
                if (scraper != null) {
                    int currentWidth = 0;
                    ImageIcon logo = this.getIcon(scraper.getLogoURL());
                    if (logo != null) {
                        currentWidth = logo.getIconWidth();
                    }
                    this.label.setIcon(logo);
                    this.label.setIconTextGap(this.maxIconWidth + 4 - currentWidth);
                    if (!scraper.isActive()) {
                        this.checkBox.setFocusable(false);
                        this.checkBox.setEnabled(false);
                        this.checkBox.setSelected(false);
                        this.label.setFocusable(false);
                        this.label.setEnabled(false);
                        if (!scraper.isEnabled()) {
                            this.label.setText("*PRO* " + this.label.getText());
                        }
                    } else {
                        this.checkBox.setFocusable(true);
                        this.checkBox.setEnabled(true);
                        this.label.setFocusable(true);
                        this.label.setEnabled(true);
                    }
                } else {
                    this.label.setIcon(null);
                    this.label.setIconTextGap(4);
                    this.checkBox.setFocusable(true);
                    this.checkBox.setEnabled(true);
                    this.label.setFocusable(true);
                    this.label.setEnabled(true);
                }
                Dimension preferredSize = this.panel.getPreferredSize();
                if (MediaScraperCheckComboBox.this.listWidth < preferredSize.width) {
                    MediaScraperCheckComboBox.this.listWidth = preferredSize.width;
                }
                if (index > -1) {
                    return this.panel;
                }
            }
            List<MediaScraper> objs = MediaScraperCheckComboBox.this.getSelectedItems();
            ArrayList<String> strs = new ArrayList<String>();
            if (objs.isEmpty()) {
                str = TmmResourceBundle.getString("ComboBox.select.mediascraper");
            } else {
                for (MediaScraper obj : objs) {
                    strs.add(((Object)obj).toString());
                }
                str = ((Object)strs).toString();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, str, index, isSelected, cellHasFocus);
        }

        private ImageIcon getIcon(URL url) {
            if (url == null) {
                return null;
            }
            try {
                URI uri = url.toURI();
                Object logo = MediaScraperCheckComboBox.this.imageCache.get(uri);
                if (logo == null) {
                    if (url.getFile().endsWith("svg")) {
                        TmmSvgIcon svgIcon = new TmmSvgIcon(uri);
                        svgIcon.setPreferredHeight(this.calculatePreferredHeight());
                        logo = svgIcon;
                    } else {
                        logo = ImageUtils.createMultiResolutionImage(IconManager.loadImageFromURL(url), this.calculatePreferredHeight());
                    }
                    MediaScraperCheckComboBox.this.imageCache.put(uri, (ImageIcon)logo);
                }
                return logo;
            }
            catch (Exception e) {
                LOGGER.debug("could not load scraper icon: {}", (Object)e.getMessage());
                return null;
            }
        }

        private int calculatePreferredHeight() {
            FontMetrics fm = MediaScraperCheckComboBox.this.getFontMetrics(MediaScraperCheckComboBox.this.getFont());
            return (int)((float)fm.getHeight() * 2.0f);
        }
    }
}

