/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JViewport;

class TmmViewport
extends JViewport {
    private static final long serialVersionUID = 3786918873070899884L;
    private final JTable fTable;
    private final List<Integer> colsWoRightGrid;

    TmmViewport(JTable table, int[] cols) {
        this.fTable = table;
        this.colsWoRightGrid = new ArrayList<Integer>(cols.length);
        for (int i : cols) {
            this.colsWoRightGrid.add(i);
        }
        this.fTable.putClientProperty("borderNotToDraw", this.colsWoRightGrid);
        this.setOpaque(false);
        this.initListeners();
    }

    private void initListeners() {
        PropertyChangeListener listener = this.createTableColumnWidthListener();
        for (int i = 0; i < this.fTable.getColumnModel().getColumnCount(); ++i) {
            this.fTable.getColumnModel().getColumn(i).addPropertyChangeListener(listener);
        }
    }

    private PropertyChangeListener createTableColumnWidthListener() {
        return evt -> this.repaint();
    }

    @Override
    public void setViewPosition(Point p) {
        super.setViewPosition(p);
        this.repaint();
    }
}

