/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.tinymediamanager.ui.components.FlatButton;

class ToolbarButton
extends FlatButton {
    private final JPopupMenu popupMenu;

    ToolbarButton(Icon baseIcon) {
        this(baseIcon, null, null);
    }

    ToolbarButton(Icon baseIcon, Icon hoverIcon) {
        this(baseIcon, hoverIcon, null);
    }

    ToolbarButton(Icon baseIcon, Icon hoverIcon, JPopupMenu popupMenu) {
        super(baseIcon);
        this.popupMenu = popupMenu;
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setVerticalTextPosition(0);
        this.setHorizontalTextPosition(0);
        this.setHideActionText(true);
        this.setRolloverIcon(hoverIcon);
        this.setPressedIcon(hoverIcon);
        this.updateUI();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ToolbarButton.this.popupMenu != null) {
                    ToolbarButton.this.popupMenu.show(ToolbarButton.this, ToolbarButton.this.getWidth() - (int)ToolbarButton.this.popupMenu.getPreferredSize().getWidth(), ToolbarButton.this.getHeight());
                }
            }
        });
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        this.setEnabled(a != null);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        this.setToolTipText(a != null ? (String)a.getValue("ShortDescription") : null);
    }

    void setIcons(Icon baseIcon, Icon hoverIcon) {
        this.setIcon(baseIcon);
        this.setRolloverIcon(hoverIcon);
        this.setPressedIcon(hoverIcon);
    }
}

