/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCheckRenderDataProvider;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableRenderDataProvider;

public class TmmTreeTableCellRenderer
extends DefaultTableCellRenderer {
    private static int expansionHandleWidth = 0;
    private static int expansionHandleHeight = 0;
    private boolean expanded = false;
    private boolean leaf = true;
    private boolean showHandle = true;
    private int nestingDepth = 0;
    private int labelTextGap = 0;
    private final JCheckBox theCheckBox;
    private JCheckBox checkBox;
    private Reference<TmmTreeTableRenderDataProvider> lastRendererRef = new WeakReference<Object>(null);
    private Reference<Object> lastRenderedValueRef = new WeakReference<Object>(null);
    private static final Border expansionBorder = new ExpansionHandleBorder();

    public TmmTreeTableCellRenderer() {
        this.theCheckBox = this.createCheckBox();
    }

    JCheckBox createCheckBox() {
        JCheckBox cb = new JCheckBox();
        cb.setSize(cb.getPreferredSize());
        cb.setBorderPainted(false);
        cb.setOpaque(false);
        return cb;
    }

    @Override
    public final void setBorder(Border b) {
        if ((b = new RestrictedInsetsBorder(b)) == expansionBorder) {
            super.setBorder(b);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(b, expansionBorder));
        }
    }

    static Icon getExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    static Icon getCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    static int getNestingWidth() {
        return TmmTreeTableCellRenderer.getExpansionHandleWidth();
    }

    static int getExpansionHandleWidth() {
        if (expansionHandleWidth == 0) {
            expansionHandleWidth = TmmTreeTableCellRenderer.getExpandedIcon().getIconWidth();
        }
        return expansionHandleWidth;
    }

    static int getExpansionHandleHeight() {
        if (expansionHandleHeight == 0) {
            expansionHandleHeight = TmmTreeTableCellRenderer.getExpandedIcon().getIconHeight();
        }
        return expansionHandleHeight;
    }

    private void setNestingDepth(int i) {
        this.nestingDepth = i;
    }

    private void setExpanded(boolean val) {
        this.expanded = val;
    }

    private void setLeaf(boolean val) {
        this.leaf = val;
    }

    private void setShowHandle(boolean val) {
        this.showHandle = val;
    }

    private void setCheckBox(JCheckBox checkBox) {
        this.checkBox = checkBox;
    }

    private boolean isLeaf() {
        return this.leaf;
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    private boolean isShowHandle() {
        return this.showHandle;
    }

    private void setLabelTextGap(int labelTextGap) {
        this.labelTextGap = labelTextGap;
    }

    private int getLabelTextGap() {
        return this.labelTextGap;
    }

    private int getNestingDepth() {
        return this.nestingDepth;
    }

    private JCheckBox getCheckBox() {
        return this.checkBox;
    }

    protected JCheckBox setUpCheckBox(TmmTreeTableCheckRenderDataProvider crendata, Object value, JCheckBox cb) {
        Boolean chSelected = crendata.isSelected(value);
        cb.setEnabled(true);
        cb.setSelected(!Boolean.FALSE.equals(chSelected));
        cb.getModel().setArmed(chSelected == null);
        cb.getModel().setPressed(chSelected == null);
        cb.setEnabled(crendata.isCheckEnabled(value));
        cb.setBackground(this.getBackground());
        return cb;
    }

    int getTheCheckBoxWidth() {
        return this.theCheckBox.getSize().width;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TmmTreeTable tbl;
        this.setForeground(null);
        this.setBackground(null);
        this.setToolTipText(null);
        this.setLabelTextGap(0);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TmmTreeNode) {
            this.setToolTipText(value.toString());
        }
        if ((tbl = (TmmTreeTable)table).isTreeColumnIndex(column)) {
            int nd;
            AbstractLayoutCache layout = tbl.getLayoutCache();
            row = tbl.convertRowIndexToModel(row);
            boolean isleaf = tbl.getTreeTableModel().isLeaf(value);
            this.setLeaf(isleaf);
            this.setShowHandle(true);
            TreePath path = layout.getPathForRow(row);
            boolean isExpanded = layout.isExpanded(path);
            this.setExpanded(isExpanded);
            int n = path == null ? 0 : (nd = path.getPathCount() - (tbl.isRootVisible() ? 1 : 2));
            if (nd < 0) {
                nd = 0;
            }
            this.setNestingDepth(nd);
            TmmTreeTableRenderDataProvider rendata = tbl.getRenderDataProvider();
            Icon icon = null;
            if (rendata != null && value != null) {
                TmmTreeTableCheckRenderDataProvider crendata;
                String displayName = rendata.getDisplayName(value);
                if (displayName != null) {
                    this.setText(displayName);
                }
                this.lastRendererRef = new WeakReference<TmmTreeTableRenderDataProvider>(rendata);
                this.lastRenderedValueRef = new WeakReference<Object>(value);
                Color fg = rendata.getForeground(value);
                if (fg != null && !isSelected) {
                    this.setForeground(fg);
                }
                icon = rendata.getIcon(value);
                JCheckBox cb = null;
                if (rendata instanceof TmmTreeTableCheckRenderDataProvider && (crendata = (TmmTreeTableCheckRenderDataProvider)rendata).isCheckable(value)) {
                    cb = this.setUpCheckBox(crendata, value, this.theCheckBox);
                }
                this.setCheckBox(cb);
            } else {
                this.setCheckBox(null);
            }
            this.setIcon(icon);
            if (icon == null || icon.getIconWidth() == 0) {
                this.setLabelTextGap(this.getIconTextGap());
            }
        } else {
            this.setCheckBox(null);
            this.setIcon(null);
            this.setShowHandle(false);
            this.lastRendererRef = new WeakReference<Object>(null);
            this.lastRenderedValueRef = new WeakReference<Object>(null);
        }
        return this;
    }

    @Override
    public String getToolTipText() {
        String toolT;
        TmmTreeTableRenderDataProvider rendata = this.lastRendererRef.get();
        Object value = this.lastRenderedValueRef.get();
        if (rendata != null && value != null && (toolT = rendata.getTooltipText(value)) != null && (toolT = toolT.trim()).length() > 0) {
            return toolT;
        }
        return super.getToolTipText();
    }

    private static class RestrictedInsetsBorder
    implements Border {
        private final Border delegate;

        public RestrictedInsetsBorder(Border delegate) {
            this.delegate = delegate;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintBorder(c, g, x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = this.delegate.getBorderInsets(c);
            if (insets.top > 1 || insets.left > 1 || insets.bottom > 1 || insets.right > 1) {
                insets = new Insets(Math.min(insets.top, 1), Math.min(insets.left, 1), Math.min(insets.bottom, 1), Math.min(insets.right, 1));
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }

    private static class ExpansionHandleBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);

        private ExpansionHandleBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            TmmTreeTableCellRenderer ren = (TmmTreeTableCellRenderer)((JComponent)c).getClientProperty(TmmTreeTableCellRenderer.class);
            if (ren == null) {
                ren = (TmmTreeTableCellRenderer)c;
            }
            if (ren.isShowHandle()) {
                this.insets.left = TmmTreeTableCellRenderer.getExpansionHandleWidth() + ren.getNestingDepth() * TmmTreeTableCellRenderer.getNestingWidth() + ren.getLabelTextGap();
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            } else {
                this.insets.left = 1;
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            }
            if (ren.getCheckBox() != null) {
                this.insets.left += ren.getCheckBox().getSize().width;
            }
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JCheckBox chBox;
            TmmTreeTableCellRenderer ren = (TmmTreeTableCellRenderer)((JComponent)c).getClientProperty(TmmTreeTableCellRenderer.class);
            if (ren == null) {
                ren = (TmmTreeTableCellRenderer)c;
            }
            if (ren.isShowHandle() && !ren.isLeaf()) {
                Icon icon = ren.isExpanded() ? TmmTreeTableCellRenderer.getExpandedIcon() : TmmTreeTableCellRenderer.getCollapsedIcon();
                int iconX = ren.getNestingDepth() * TmmTreeTableCellRenderer.getNestingWidth();
                int iconY = icon.getIconHeight() < height ? height / 2 - icon.getIconHeight() / 2 : 0;
                icon.paintIcon(c, g, iconX, iconY);
            }
            if ((chBox = ren.getCheckBox()) != null) {
                int chBoxX = TmmTreeTableCellRenderer.getExpansionHandleWidth() + ren.getNestingDepth() * TmmTreeTableCellRenderer.getNestingWidth();
                Rectangle bounds = chBox.getBounds();
                int chBoxY = bounds.getHeight() < (double)height ? height / 2 - (int)bounds.getHeight() / 2 : 0;
                Dimension chDim = chBox.getSize();
                Graphics gch = g.create(chBoxX, chBoxY, chDim.width, chDim.height);
                chBox.paint(gch);
            }
        }
    }
}

