/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.ExportLogAction;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class BugReportDialog
extends TmmDialog {
    private static final long serialVersionUID = 1992385114573899815L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BugReportDialog.class);
    private static final String DIALOG_ID = "bugReportdialog";

    public BugReportDialog() {
        super(TmmResourceBundle.getString("BugReport"), DIALOG_ID);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][][450lp,grow]", "[][20lp][][][20lp][][][]"));
        JTextArea taDescription = new JTextArea();
        taDescription.setOpaque(false);
        taDescription.setWrapStyleWord(true);
        taDescription.setLineWrap(true);
        taDescription.setEditable(false);
        taDescription.setText(TmmResourceBundle.getString("BugReport.description"));
        panelContent.add((Component)taDescription, "cell 0 0 3 1,growx");
        JLabel lblStep1 = new JLabel(TmmResourceBundle.getString("BugReport.step1"));
        panelContent.add((Component)lblStep1, "cell 0 2");
        JTextArea taStep1 = new JTextArea();
        taStep1.setWrapStyleWord(true);
        taStep1.setLineWrap(true);
        taStep1.setText(TmmResourceBundle.getString("BugReport.step1.description"));
        taStep1.setOpaque(false);
        taStep1.setEditable(false);
        panelContent.add((Component)taStep1, "cell 2 2,growx");
        JButton btnSaveLogs = new JButton(TmmResourceBundle.getString("BugReport.createlogs"));
        btnSaveLogs.addActionListener(new ExportLogAction());
        panelContent.add((Component)btnSaveLogs, "cell 2 3");
        JLabel lblStep2 = new JLabel(TmmResourceBundle.getString("BugReport.step2"));
        panelContent.add((Component)lblStep2, "cell 0 5,alignx left,aligny top");
        JTextArea taStep2 = new JTextArea();
        taStep2.setLineWrap(true);
        taStep2.setWrapStyleWord(true);
        taStep2.setOpaque(false);
        taStep2.setEditable(false);
        taStep2.setText(TmmResourceBundle.getString("BugReport.step2.description"));
        panelContent.add((Component)taStep2, "cell 2 5,growx");
        JButton btnCreateIssue = new JButton(TmmResourceBundle.getString("BugReport.craeteissue"));
        btnCreateIssue.addActionListener(e -> {
            String baseUrl = "https://gitlab.com/tinyMediaManager/tinyMediaManager/issues/new?issue[description]=";
            String params = "Version: " + ReleaseInfo.getRealVersion() + "  ";
            params = params + "\nBuild: " + ReleaseInfo.getRealBuildDate() + "  ";
            params = params + "\nOS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "  ";
            params = params + "\nJDK: " + System.getProperty("java.version") + " " + System.getProperty("os.arch") + " " + System.getProperty("java.vendor") + "  ";
            params = params + "\n\n__What is the actual behaviour?__  \n\n";
            params = params + "\n\n__What is the expected behaviour?__  \n\n";
            params = params + "\n\n__Steps to reproduce:__  \n\n";
            params = params + "\n\n__Additional__  \nHave you attached the logfile from the day it happened?";
            Object url = "";
            try {
                url = baseUrl + URLEncoder.encode(params, "UTF-8");
                TmmUIHelper.browseUrl((String)url);
            }
            catch (Exception e1) {
                LOGGER.error("FAQ", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelContent.add((Component)btnCreateIssue, "cell 2 6,alignx left,aligny center");
        JLabel lblHintIcon = new JLabel(IconManager.HINT);
        panelContent.add((Component)lblHintIcon, "cell 1 7,alignx left,aligny center");
        JLabel lblHint = new JLabel(TmmResourceBundle.getString("BugReport.languagehint"));
        panelContent.add((Component)lblHint, "cell 2 7,growx,aligny top");
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.setIcon(IconManager.CANCEL_INV);
        btnClose.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(btnClose);
    }
}

