/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class CleanUpUnwantedFilesDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpUnwantedFilesDialog.class);
    private final EventList<FileContainer> results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
    private final TmmTable table = new TmmTable((TableModel)((Object)new TmmTableModel<FileContainer>(this.results, new CleanUpTableFormat())));
    private final JButton btnClean;
    private final JProgressBar progressBar;
    private final JLabel lblProgressAction;

    public CleanUpUnwantedFilesDialog(List<MediaEntity> selectedEntities) {
        super(TmmResourceBundle.getString("cleanupfiles"), "cleanupEntities");
        JScrollPane scrollPane = new JScrollPane();
        this.table.configureScrollPane(scrollPane);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        this.btnClean = new JButton(TmmResourceBundle.getString("Button.deleteselected"));
        this.btnClean.setIcon(IconManager.DELETE_INV);
        this.btnClean.addActionListener(arg0 -> this.cleanFiles(this.table));
        this.addButton(this.btnClean);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addButton(btnClose);
        TvShowCleanUpWorker worker = new TvShowCleanUpWorker(selectedEntities);
        worker.execute();
    }

    private void cleanFiles(JTable table) {
        int[] rows = table.getSelectedRows();
        ArrayList<FileContainer> fileList = new ArrayList<FileContainer>();
        for (int row : rows) {
            FileContainer selectedFile = (FileContainer)this.results.get(row);
            try {
                fileList.add(selectedFile);
                LOGGER.info("Deleting File - {}", (Object)selectedFile.file);
                Utils.deleteFileWithBackup(selectedFile.file, selectedFile.entity.getDataSource());
            }
            catch (Exception e) {
                LOGGER.error("Could not delete file {} - {}", (Object)selectedFile.file, (Object)e.getMessage());
            }
        }
        this.results.removeAll(fileList);
    }

    private class TvShowCleanUpWorker
    extends SwingWorker<Void, Void> {
        private final List<MediaEntity> selectedEntities;

        private TvShowCleanUpWorker(List<MediaEntity> entities) {
            this.selectedEntities = entities;
        }

        @Override
        protected Void doInBackground() {
            CleanUpUnwantedFilesDialog.this.btnClean.setEnabled(false);
            this.startProgressBar();
            List<String> regexPatterns = Settings.getInstance().getCleanupFileType();
            this.selectedEntities.sort(Comparator.comparing(MediaEntity::getTitle));
            HashSet<Path> fileList = new HashSet<Path>();
            for (MediaEntity entity : this.selectedEntities) {
                for (Path file : Utils.getUnknownFilesByRegex(entity.getPathNIO(), regexPatterns)) {
                    if (fileList.contains(file)) continue;
                    FileContainer fileContainer = new FileContainer();
                    fileContainer.entity = entity;
                    fileContainer.file = file;
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(fileContainer.file, BasicFileAttributes.class, new LinkOption[0]);
                        fileContainer.filesize = attrs.size();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CleanUpUnwantedFilesDialog.this.results.add((Object)fileContainer);
                    fileList.add(file);
                }
            }
            return null;
        }

        @Override
        protected void done() {
            this.stopProgressBar();
            SwingUtilities.invokeLater(() -> {
                CleanUpUnwantedFilesDialog.this.btnClean.setEnabled(true);
                TableColumnResizer.adjustColumnPreferredWidths(CleanUpUnwantedFilesDialog.this.table);
                CleanUpUnwantedFilesDialog.this.table.getParent().invalidate();
                CleanUpUnwantedFilesDialog.this.results.sort(Comparator.comparing(FileContainer::getFileName));
            });
        }

        private void startProgressBar() {
            SwingUtilities.invokeLater(() -> {
                CleanUpUnwantedFilesDialog.this.progressBar.setVisible(true);
                CleanUpUnwantedFilesDialog.this.progressBar.setIndeterminate(true);
                CleanUpUnwantedFilesDialog.this.lblProgressAction.setText("movie.searchunwanted");
            });
        }

        private void stopProgressBar() {
            SwingUtilities.invokeLater(() -> {
                CleanUpUnwantedFilesDialog.this.progressBar.setVisible(false);
                CleanUpUnwantedFilesDialog.this.progressBar.setIndeterminate(false);
                CleanUpUnwantedFilesDialog.this.lblProgressAction.setText("");
            });
        }
    }

    private static class FileContainer {
        MediaEntity entity;
        Path file;
        long filesize;

        private FileContainer() {
        }

        String getFilesizeInKilobytes() {
            DecimalFormat df = new DecimalFormat("#0.00");
            return df.format((double)this.filesize / 1000.0) + " kB";
        }

        String getExtension() {
            return FilenameUtils.getExtension((String)this.file.getFileName().toString());
        }

        String getFileName() {
            return this.file.toString();
        }
    }

    private static class CleanUpTableFormat
    extends TmmTableFormat<FileContainer> {
        public CleanUpTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", fileContainer -> fileContainer.file.toString(), String.class);
            col.setColumnTooltip(fileContainer -> fileContainer.file.toString());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.size"), "size", FileContainer::getFilesizeInKilobytes, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filetype"), "type", FileContainer::getExtension, String.class);
            this.addColumn(col);
        }
    }
}

