/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class IdEditorDialog
extends TmmDialog {
    private final MediaIdTable.MediaId idToEdit;
    private Set<String> providerIds;
    private JComboBox cbProviderId;
    private JTextField tfId;

    public IdEditorDialog(Window owner, String title, MediaIdTable.MediaId mediaId, ScraperType type) {
        super(owner, title, (String)null);
        this.idToEdit = mediaId;
        this.providerIds = new HashSet<String>();
        for (MediaScraper scraper : MediaScraper.getMediaScrapers(type)) {
            this.providerIds.add(scraper.getId());
        }
        this.initComponents();
        this.cbProviderId.setSelectedItem(this.idToEdit.key);
        this.tfId.setText(this.idToEdit.value);
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][100lp:n,grow]", "[][]"));
        JLabel lblProviderIdT = new JLabel(TmmResourceBundle.getString("metatag.id.source"));
        panelContent.add((Component)lblProviderIdT, "cell 0 0,alignx trailing");
        this.cbProviderId = new AutocompleteComboBox<String>(this.providerIds);
        panelContent.add((Component)this.cbProviderId, "cell 1 0,growx");
        JLabel lblIdT = new JLabel(TmmResourceBundle.getString("metatag.id"));
        panelContent.add((Component)lblIdT, "cell 0 1,alignx trailing");
        this.tfId = new JTextField();
        panelContent.add((Component)this.tfId, "cell 1 1,growx");
        this.tfId.setColumns(10);
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.addActionListener(e -> this.setVisible(false));
        this.addButton(btnCancel);
        JButton btnOk = new JButton(TmmResourceBundle.getString("Button.save"));
        btnOk.addActionListener(e -> {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tfId.getText(), (String)this.cbProviderId.getSelectedItem()})) {
                JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("id.empty"));
                return;
            }
            this.idToEdit.key = (String)this.cbProviderId.getSelectedItem();
            this.idToEdit.value = this.tfId.getText();
            this.setVisible(false);
        });
        this.addDefaultButton(btnOk);
    }
}

