/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.IdEditorDialog;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class PersonEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 535326891112742179L;
    private final Person personToEdit;
    private final EventList<MediaIdTable.MediaId> ids;
    private JTextField tfName;
    private JTextField tfRole;
    private JTextField tfImageUrl;
    private JTextField tfProfileUrl;
    private TmmTable tableIds;

    public PersonEditorDialog(Window owner, String title, Person person) {
        super(owner, title, "personEditor");
        this.personToEdit = person;
        this.ids = MediaIdTable.convertIdMapToEventList(this.personToEdit.getIds());
        this.initComponents();
        this.tfName.setText(this.personToEdit.getName());
        this.tfRole.setText(this.personToEdit.getRole());
        this.tfImageUrl.setText(this.personToEdit.getThumbUrl());
        this.tfProfileUrl.setText(this.personToEdit.getProfileUrl());
        if (person.getType() != Person.Type.ACTOR) {
            this.tfRole.setEnabled(false);
        }
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add(panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][500lp:n,grow][]", "[][][][][][][][20lp]"));
        JLabel lblNameT = new JLabel(TmmResourceBundle.getString("metatag.name"));
        panelContent.add((Component)lblNameT, "cell 0 0,alignx trailing");
        this.tfName = new JTextField();
        panelContent.add((Component)this.tfName, "cell 1 0,growx");
        this.tfName.setColumns(10);
        JLabel lblRoleT = new JLabel(TmmResourceBundle.getString("metatag.role"));
        panelContent.add((Component)lblRoleT, "cell 0 1,alignx trailing");
        this.tfRole = new JTextField();
        panelContent.add((Component)this.tfRole, "cell 1 1,growx");
        this.tfRole.setColumns(10);
        JLabel lblImageUrlT = new JLabel(TmmResourceBundle.getString("image.url"));
        panelContent.add((Component)lblImageUrlT, "cell 0 2,alignx trailing");
        this.tfImageUrl = new JTextField();
        panelContent.add((Component)this.tfImageUrl, "cell 1 2,growx");
        this.tfImageUrl.setColumns(10);
        JButton btnShowImage = new JButton(IconManager.IMAGE_INV);
        btnShowImage.setToolTipText(TmmResourceBundle.getString("image.show"));
        btnShowImage.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.tfImageUrl.getText())) {
                try {
                    URL url = new URL(this.tfImageUrl.getText());
                    ImagePreviewDialog dialog = new ImagePreviewDialog(url.toExternalForm());
                    ((Dialog)dialog).setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        panelContent.add((Component)btnShowImage, "cell 2 2");
        JLabel lblProfileUrlT = new JLabel(TmmResourceBundle.getString("profile.url"));
        panelContent.add((Component)lblProfileUrlT, "cell 0 3,alignx trailing");
        this.tfProfileUrl = new JTextField();
        panelContent.add((Component)this.tfProfileUrl, "cell 1 3,growx");
        this.tfProfileUrl.setColumns(10);
        TmmLabel lblIds = new TmmLabel(TmmResourceBundle.getString("metatag.ids"));
        panelContent.add((Component)lblIds, "cell 0 4,alignx trailing");
        JScrollPane scrollPaneIds = new JScrollPane();
        panelContent.add((Component)scrollPaneIds, "cell 1 4 1 4,grow");
        this.tableIds = new MediaIdTable(this.ids);
        this.tableIds.configureScrollPane(scrollPaneIds);
        SquareIconButton btnAddId = new SquareIconButton(new AddIdAction());
        panelContent.add((Component)btnAddId, "cell 0 5,alignx right,aligny top");
        SquareIconButton btnRemoveId = new SquareIconButton(new RemoveIdAction());
        panelContent.add((Component)btnRemoveId, "cell 0 6,alignx right,aligny top");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.addActionListener(e -> this.setVisible(false));
        this.addButton(btnCancel);
        JButton btnOk = new JButton(TmmResourceBundle.getString("Button.save"));
        btnOk.addActionListener(e -> {
            this.personToEdit.setName(this.tfName.getText());
            this.personToEdit.setRole(this.tfRole.getText());
            this.personToEdit.setThumbUrl(this.tfImageUrl.getText());
            this.personToEdit.setProfileUrl(this.tfProfileUrl.getText());
            for (MediaIdTable.MediaId id : this.ids) {
                try {
                    Integer value = Integer.parseInt(id.value);
                    this.personToEdit.setId(id.key, value);
                }
                catch (NumberFormatException ex) {
                    this.personToEdit.setId(id.key, id.value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.personToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId(entry.getKey());
                if (this.ids.contains((Object)id)) continue;
                removeIds.add(entry.getKey());
            }
            for (String id : removeIds) {
                this.personToEdit.setId(id, null);
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnOk);
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        public RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = PersonEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = PersonEditorDialog.this.tableIds.convertRowIndexToModel(row);
                PersonEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        public AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            IdEditorDialog dialog = new IdEditorDialog(SwingUtilities.getWindowAncestor(PersonEditorDialog.this.tableIds), TmmResourceBundle.getString("id.add"), mediaId, ScraperType.MOVIE);
            dialog.setVisible(true);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                PersonEditorDialog.this.ids.add((Object)mediaId);
            }
        }
    }
}

