/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;

public class MovieMatcherEditor
extends AbstractMatcherEditor<Movie> {
    private final Set<IMovieUIFilter> filters = new HashSet<IMovieUIFilter>();
    private final PropertyChangeListener filterChangeListener = evt -> this.updateFiltering();
    private boolean filtersActive = true;

    public void addFilter(IMovieUIFilter filter) {
        filter.addPropertyChangeListener(this.filterChangeListener);
        this.filters.add(filter);
    }

    public void setFilterValues(List<AbstractSettings.UIFilters> values) {
        for (IMovieUIFilter filter : this.filters) {
            AbstractSettings.UIFilters uiFilters = values.stream().filter(uiFilter -> uiFilter.id.equals(filter.getId())).findFirst().orElse(null);
            if (uiFilters != null) {
                filter.setFilterState(uiFilters.state);
                filter.setFilterValue(uiFilters.filterValue);
                continue;
            }
            filter.setFilterState(ITmmUIFilter.FilterState.INACTIVE);
        }
        this.updateFiltering();
    }

    public void setFiltersActive(boolean filtersActive) {
        this.filtersActive = filtersActive;
        this.updateFiltering();
    }

    public boolean isFiltersActive() {
        return this.filtersActive;
    }

    public void clearFilters() {
        for (IMovieUIFilter filter : this.filters) {
            filter.setFilterState(ITmmUIFilter.FilterState.INACTIVE);
            filter.clearFilter();
        }
        this.updateFiltering();
    }

    private void updateFiltering() {
        SwingUtilities.invokeLater(() -> {
            MovieMatcher matcher = this.filtersActive ? new MovieMatcher(new HashSet<IMovieUIFilter>(this.filters)) : new MovieMatcher(Collections.emptySet());
            this.fireChanged(matcher);
        });
        if (MovieModuleManager.getInstance().getSettings().isStoreUiFilters()) {
            ArrayList<AbstractSettings.UIFilters> filterValues = new ArrayList<AbstractSettings.UIFilters>();
            for (IMovieUIFilter filter : this.filters) {
                if (filter.getFilterState() == ITmmUIFilter.FilterState.INACTIVE) continue;
                AbstractSettings.UIFilters uiFilters = new AbstractSettings.UIFilters();
                uiFilters.id = filter.getId();
                uiFilters.state = filter.getFilterState();
                uiFilters.filterValue = filter.getFilterValueAsString();
                filterValues.add(uiFilters);
            }
            MovieModuleManager.getInstance().getSettings().setUiFilters(filterValues);
            MovieModuleManager.getInstance().getSettings().saveSettings();
        }
    }

    public Set<IMovieUIFilter> getFilters() {
        return this.filters;
    }

    private static class MovieMatcher
    implements Matcher<Movie> {
        private final Set<IMovieUIFilter> filters;

        public MovieMatcher(Set<IMovieUIFilter> filters) {
            this.filters = filters;
        }

        public boolean matches(Movie movie) {
            for (IMovieUIFilter filter : this.filters) {
                switch (filter.getFilterState()) {
                    case ACTIVE: {
                        if (filter.accept(movie)) break;
                        return false;
                    }
                    case ACTIVE_NEGATIVE: {
                        if (!filter.accept(movie)) break;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

