/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieTextMatcherEditor
extends AbstractMatcherEditor<Movie> {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final JTextComponent textComponent;
    private String normalizedFilterText;
    private Pattern filterPattern;

    public MovieTextMatcherEditor(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MovieTextMatcherEditor.this.refilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MovieTextMatcherEditor.this.refilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MovieTextMatcherEditor.this.refilter();
            }
        });
    }

    private void refilter() {
        this.normalizedFilterText = StrgUtils.normalizeString(this.textComponent.getText());
        try {
            this.filterPattern = Pattern.compile(this.normalizedFilterText, 2);
            this.fireChanged(new MovieMatcher());
        }
        catch (PatternSyntaxException ignore) {
            this.filterPattern = null;
        }
    }

    private class MovieMatcher
    implements ca.odell.glazedlists.matchers.Matcher<Movie> {
        private MovieMatcher() {
        }

        public boolean matches(Movie movie) {
            Matcher matcher;
            if (StringUtils.isBlank((CharSequence)MovieTextMatcherEditor.this.normalizedFilterText) || MovieTextMatcherEditor.this.filterPattern == null) {
                return true;
            }
            if (MovieTextMatcherEditor.this.settings.getTitle() && StringUtils.isNotBlank((CharSequence)movie.getTitle()) && (matcher = MovieTextMatcherEditor.this.filterPattern.matcher(StrgUtils.normalizeString(movie.getTitle()))).find()) {
                return true;
            }
            if (MovieTextMatcherEditor.this.settings.getSortableTitle() && StringUtils.isNotBlank((CharSequence)movie.getTitleSortable()) && (matcher = MovieTextMatcherEditor.this.filterPattern.matcher(StrgUtils.normalizeString(movie.getTitleSortable()))).find()) {
                return true;
            }
            if (MovieTextMatcherEditor.this.settings.getOriginalTitle() && StringUtils.isNotBlank((CharSequence)movie.getOriginalTitle()) && (matcher = MovieTextMatcherEditor.this.filterPattern.matcher(StrgUtils.normalizeString(movie.getOriginalTitle()))).find()) {
                return true;
            }
            if (MovieTextMatcherEditor.this.settings.getSortableOriginalTitle() && StringUtils.isNotBlank((CharSequence)movie.getOriginalTitleSortable()) && (matcher = MovieTextMatcherEditor.this.filterPattern.matcher(StrgUtils.normalizeString(movie.getOriginalTitleSortable()))).find()) {
                return true;
            }
            return MovieTextMatcherEditor.this.settings.getSortTitle() && StringUtils.isNotBlank((CharSequence)movie.getSortTitle()) && (matcher = MovieTextMatcherEditor.this.filterPattern.matcher(StrgUtils.normalizeString(movie.getSortTitle()))).find();
        }
    }
}

