/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class MovieAddDatasourceAction
extends TmmAction {
    private static final long serialVersionUID = -4417368111497702010L;

    public MovieAddDatasourceAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.datasource.add"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.datasource.add"));
        this.putValue("SmallIcon", IconManager.ADD);
        this.putValue("SwingLargeIconKey", IconManager.ADD);
    }

    @Override
    protected void processAction(ActionEvent e) {
        SwingUtilities.invokeLater(() -> {
            String path = TmmProperties.getInstance().getProperty("movie.datasource.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.datasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                MovieModuleManager.getInstance().getSettings().addMovieDataSources(file.toAbsolutePath().toString());
                MovieModuleManager.getInstance().getSettings().saveSettings();
                TmmProperties.getInstance().putProperty("movie.datasource.path", file.toAbsolutePath().toString());
            }
        });
    }
}

