/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.CleanUpUnwantedFilesDialog;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieCleanUpFilesAction
extends TmmAction {
    private static final long serialVersionUID = -2029243504238273721L;

    public MovieCleanUpFilesAction() {
        this.putValue("Name", TmmResourceBundle.getString("cleanupfiles"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("cleanupfiles.desc"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MediaEntity> selectedMovies = new ArrayList<MediaEntity>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        CleanUpUnwantedFilesDialog dialog = new CleanUpUnwantedFilesDialog(selectedMovies);
        dialog.setVisible(true);
    }
}

