/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieClearImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = -5089957097690621345L;

    public MovieClearImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.clearimagecache"));
        this.putValue("SwingLargeIconKey", "");
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (Movie movie : selectedMovies) {
            ImageCache.clearImageCacheForMediaEntity(movie);
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

