/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieMissingArtworkDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieDownloadMissingArtworkDialog;

public class MovieDownloadMissingArtworkAction
extends TmmAction {
    private static final long serialVersionUID = -4006932829840795735L;

    public MovieDownloadMissingArtworkAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.downloadmissingartwork"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieDownloadMissingArtworkDialog dialog = new MovieDownloadMissingArtworkDialog();
        dialog.setVisible(true);
        MovieSearchAndScrapeOptions options = dialog.getMovieSearchAndScrapeOptions();
        options.loadDefaults();
        List<MovieScraperMetadataConfig> config = dialog.getMovieScraperMetadataConfig();
        if (dialog.shouldStartScrape() && ScraperMetadataConfig.containsAnyArtwork(config)) {
            MovieMissingArtworkDownloadTask task = new MovieMissingArtworkDownloadTask(selectedMovies, options, config);
            TmmTaskManager.getInstance().addDownloadTask(task);
        }
    }
}

