/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieExporterDialog;

public class MovieExportAction
extends TmmAction {
    private static final long serialVersionUID = -6731682301579049379L;

    public MovieExportAction() {
        this.putValue("SwingLargeIconKey", IconManager.EXPORT);
        this.putValue("SmallIcon", IconManager.EXPORT);
        this.putValue("Name", TmmResourceBundle.getString("movie.export"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> movies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (movies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieExporterDialog dialog = new MovieExporterDialog(movies);
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
    }
}

